/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import com.prosc.shared.StringUtils;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativeDateFormat
extends Format {
    private final String pastTerm = "ago";
    private String futureTerm = "from now";

    @Override
    public StringBuffer format(Object obj, @NotNull StringBuffer toAppendTo, @NotNull FieldPosition pos) {
        String str = this.formatWorker((Date)obj);
        pos.setEndIndex(str.length());
        return toAppendTo.append(str);
    }

    private String formatWorker(Date date) {
        if (date == null) {
            return "";
        }
        long now = System.currentTimeMillis();
        long when = date.getTime();
        int seconds = (int)Math.round((double)(when - now) / 1000.0);
        boolean inThePast = seconds < 0;
        String term = StringUtils.emptyStringForNull(inThePast ? "ago" : this.futureTerm);
        if (!StringUtils.isEmpty(term) && !Character.isWhitespace(term.charAt(0))) {
            term = " " + term;
        }
        if ((seconds = Math.abs(seconds)) < 60) {
            return seconds == 1 ? "one second " + term : this.numFormat(seconds) + " seconds" + term;
        }
        if (seconds < 120) {
            return "a minute" + term;
        }
        int minutes = seconds / 60;
        if (seconds < 2700) {
            return minutes + " minutes" + term;
        }
        if (seconds < 5400) {
            return "an hour" + term;
        }
        int hours = minutes / 60;
        if (seconds < 86400) {
            return hours + " hours" + term;
        }
        if (seconds < 172800) {
            return inThePast ? "yesterday" : "tomorrow";
        }
        int days = hours / 24;
        if (seconds < 2592000) {
            return days + " days" + term;
        }
        int months = days / 30;
        if (seconds < 31104000) {
            return months <= 1 ? "one month" + term : this.numFormat(months) + " months" + term;
        }
        int years = days / 365;
        return years <= 1 ? "one year" + term : this.numFormat(years) + " years" + term;
    }

    private String numFormat(int howMany) {
        switch (howMany) {
            case 0: {
                return "zero";
            }
            case 1: {
                return "one";
            }
            case 2: {
                return "two";
            }
            case 3: {
                return "three";
            }
            case 4: {
                return "four";
            }
            case 5: {
                return "five";
            }
            case 6: {
                return "six";
            }
            case 7: {
                return "seven";
            }
            case 8: {
                return "eight";
            }
            case 9: {
                return "nine";
            }
            case 10: {
                return "ten";
            }
            case 11: {
                return "eleven";
            }
            case 12: {
                return "twelve";
            }
            case 13: {
                return "thirteen";
            }
        }
        return String.valueOf(howMany);
    }

    @Override
    public Object parseObject(String source, @NotNull ParsePosition pos) {
        throw new UnsupportedOperationException("RelativeDateFormat does not support parsing text input");
    }

    public void setFutureTerm(@Nullable String futureTerm) {
        this.futureTerm = futureTerm;
    }

    public String getFutureTerm() {
        return this.futureTerm;
    }
}

