/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import com.prosc.shared.StringUtils;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexibleTimeFormat
extends Format {
    private final DateTimeFormatter[] formatters = new DateTimeFormatter[]{DateTimeFormatter.ISO_TIME, DateTimeFormatter.ISO_LOCAL_TIME, DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL), DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG), DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM), DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT), DateTimeFormatter.ofPattern("hmma"), DateTimeFormatter.ofPattern("hmma"), DateTimeFormatter.ofPattern("ha"), DateTimeFormatter.ofPattern("h:mma"), DateTimeFormatter.ofPattern("h:mma"), DateTimeFormatter.ofPattern("h:mm:ssa"), DateTimeFormatter.ofPattern("h:mm:ssa"), DateTimeFormatter.ofPattern("Hmmss"), DateTimeFormatter.ofPattern("Hmm"), DateTimeFormatter.ofPattern("H"), DateTimeFormatter.ofPattern("H"), DateTimeFormatter.ofPattern("H:mm:ss"), DateTimeFormatter.ofPattern("H:mm")};

    @Override
    public StringBuffer format(Object obj, @NotNull StringBuffer toAppendTo, @NotNull FieldPosition pos) {
        String formatted = ((LocalTime)obj).format(DateTimeFormatter.ISO_TIME);
        return toAppendTo.append(formatted);
    }

    @Override
    public LocalTime parseObject(String source) throws ParseException {
        return (LocalTime)super.parseObject(source);
    }

    @Override
    public LocalTime parseObject(String source, @NotNull ParsePosition pos) {
        try {
            LocalTime parsed = this.parseLocalTime(source == null ? null : source.substring(pos.getIndex()));
            pos.setIndex(source.length());
            return parsed;
        }
        catch (Exception e) {
            pos.setErrorIndex(pos.getIndex());
            return null;
        }
    }

    @Nullable
    public LocalTime parseLocalTime(@Nullable String s) {
        String string = s = s == null ? null : s.replaceAll(" ", "").toUpperCase();
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        for (DateTimeFormatter f : this.formatters) {
            try {
                return LocalTime.parse(s, f);
            }
            catch (Exception exception) {
            }
        }
        throw new RuntimeException("Could not parse time " + s);
    }
}

