/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SQLQueryBuilder {
    private WhichPart currentPart = WhichPart.Select;
    private StringBuilder sql = new StringBuilder(128);
    private List<Object> bindings = new ArrayList<Object>();
    private QualifierBuilder qualifierBuilder;
    private String delim;
    private boolean empty = true;

    public SQLQueryBuilder(@NotNull String sqlPreamble, Object ... bindings) {
        this.sql.append(sqlPreamble);
        this.bindings.addAll(Arrays.asList(bindings));
        this._appendWhitespace();
    }

    public static final SQLQueryBuilder falseInstance() {
        SQLQueryBuilder result = new SQLQueryBuilder("", new Object[0]);
        result.and().where("FALSE");
        return result;
    }

    private void _appendWhitespace() {
        if (this.sql.length() != 0 && !Character.isWhitespace(this.sql.charAt(this.sql.length() - 1))) {
            this.sql.append(' ');
        }
    }

    private void _appendDelimOptional() {
        if (this.delim != null) {
            this.sql.append(this.delim);
        } else {
            this.delim = ", ";
        }
    }

    public SQLQueryBuilder field(@NotNull String column) {
        this.currentPart.assertOn(WhichPart.Select);
        this._appendDelimOptional();
        this.sql.append(column);
        return this;
    }

    public SQLQueryBuilder from(@NotNull String tablesAndJoins) {
        if (this.currentPart == WhichPart.Select) {
            this.currentPart = WhichPart.From;
        }
        this.currentPart.assertOn(WhichPart.From);
        this._appendWhitespace();
        this.sql.append("FROM ");
        this.sql.append(tablesAndJoins);
        this._appendWhitespace();
        this.currentPart = WhichPart.Where;
        this.delim = null;
        return this;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private QualifierBuilder _createQualifierBuilder(LogicalOp lop) {
        if (this.currentPart.isBefore(WhichPart.Where)) {
            this.currentPart = WhichPart.Where;
            if (!this.sql.toString().toLowerCase().trim().endsWith("where")) {
                this._appendWhitespace();
                this.sql.append("WHERE ");
            }
        }
        this.currentPart.assertOn(WhichPart.Where);
        if (this.qualifierBuilder != null) {
            if (this.qualifierBuilder.op != lop) {
                throw new IllegalStateException("There is already a top-level qualifierBuilder with operator \"" + (Object)((Object)this.qualifierBuilder.op) + "\" on this builder. You must nest your \"" + (Object)((Object)lop) + "\" within this one.");
            }
            return this.qualifierBuilder;
        }
        this.qualifierBuilder = new QualifierBuilder(lop);
        return this.qualifierBuilder;
    }

    public QualifierBuilder and() {
        return this._createQualifierBuilder(LogicalOp.and);
    }

    public QualifierBuilder or() {
        return this._createQualifierBuilder(LogicalOp.or);
    }

    @NotNull
    private SQLQueryBuilder _groupOrOrder(@NotNull WhichPart newPart, @NotNull String sqlTypeString, @NotNull String orderByFragment) {
        this.closeCurrentQualifier();
        if (this.currentPart.isBefore(WhichPart.From)) {
            throw new IllegalArgumentException("You must specify a \"FROM\" clause first");
        }
        if (this.currentPart.isAfter(newPart)) {
            throw new IllegalArgumentException("Already added a " + (Object)((Object)this.currentPart) + ", cannot add " + (Object)((Object)newPart));
        }
        if (this.currentPart.isBefore(newPart)) {
            this.currentPart = newPart;
            this.delim = null;
            this._appendWhitespace();
            this.sql.append(sqlTypeString);
        }
        this.currentPart.assertOn(newPart);
        this._appendDelimOptional();
        this.sql.append(orderByFragment);
        return this;
    }

    public SQLQueryBuilder orderBy(@NotNull String orderByFragment) {
        return this._groupOrOrder(WhichPart.Order, "ORDER BY ", orderByFragment);
    }

    public SQLQueryBuilder groupBy(@NotNull String groupByFragment) {
        return this._groupOrOrder(WhichPart.Group, "GROUP BY ", groupByFragment);
    }

    public SQLQueryBuilder limit(@NotNull Object limit) {
        this._groupOrOrder(WhichPart.Limit, "LIMIT ", limit.toString());
        this.currentPart = WhichPart.Done;
        return this;
    }

    public String getSQL() {
        this.closeCurrentQualifier();
        return this.sql.toString();
    }

    public List<Object> getBindings() {
        this.closeCurrentQualifier();
        return Collections.unmodifiableList(this.bindings);
    }

    private void closeCurrentQualifier() {
        if (this.qualifierBuilder != null) {
            this.qualifierBuilder.close();
            this.qualifierBuilder = null;
        }
    }

    public void append(String s) {
        this.sql.append(s);
    }

    static enum WhichPart {
        Select,
        From,
        Where,
        Order,
        Group,
        Limit,
        Done;


        public void assertOn(WhichPart part) {
            if (this != part) {
                throw new IllegalStateException((Object)((Object)part) + " has already been called");
            }
        }

        public boolean isBefore(WhichPart otherPart) {
            return this.compareTo(otherPart) < 0;
        }

        public boolean isAfter(WhichPart otherPart) {
            return this.compareTo(otherPart) > 0;
        }
    }

    public static enum LogicalOp {
        and,
        or;

    }

    public final class QualifierBuilder {
        private final LogicalOp op;
        private LogicalOp delim;
        private QualifierBuilder nestedQualifierBuilder;

        private QualifierBuilder(LogicalOp op) {
            this.op = op;
        }

        private void _appendDelimiterIfNecessary() {
            if (this.delim == null) {
                this.delim = this.op;
                SQLQueryBuilder.this.sql.append("(");
            } else {
                SQLQueryBuilder.this._appendWhitespace();
                SQLQueryBuilder.this.sql.append((Object)this.delim).append(" ");
            }
        }

        public QualifierBuilder where(String sqlFragment) {
            this._appendDelimiterIfNecessary();
            SQLQueryBuilder.this.sql.append(sqlFragment);
            SQLQueryBuilder.this.empty = false;
            return this;
        }

        public QualifierBuilder where(String sqlFragment, Object ... bindings) {
            this._appendDelimiterIfNecessary();
            SQLQueryBuilder.this.sql.append(sqlFragment);
            SQLQueryBuilder.this.bindings.addAll(Arrays.asList(bindings));
            SQLQueryBuilder.this.empty = false;
            return this;
        }

        public QualifierBuilder whereIn(String sqlFragment, Object[] multipleValues) {
            this._closeNestedQualifier();
            if (!sqlFragment.endsWith("IN ?") && !sqlFragment.endsWith("IN ?)")) {
                throw new IllegalArgumentException("sqlFragment should end with exact string \" IN ?\", to be replaced by IN (?, ?, ?, ?, ...). Instead, we got: " + sqlFragment);
            }
            this._appendDelimiterIfNecessary();
            if (multipleValues.length == 0) {
                SQLQueryBuilder.this.sql.append("false");
                return this;
            }
            int qIndex = sqlFragment.lastIndexOf("?");
            SQLQueryBuilder.this.sql.append(sqlFragment.substring(0, qIndex));
            SQLQueryBuilder.this.sql.append("(");
            for (int i = 0; i < multipleValues.length; ++i) {
                Object eachValue = multipleValues[i];
                if (i != 0) {
                    SQLQueryBuilder.this.sql.append(", ");
                }
                SQLQueryBuilder.this.sql.append("?");
                SQLQueryBuilder.this.bindings.add(eachValue);
            }
            if (sqlFragment.endsWith(")")) {
                SQLQueryBuilder.this.sql.append(sqlFragment.substring(qIndex + 1));
            } else {
                SQLQueryBuilder.this.sql.append(")");
            }
            SQLQueryBuilder.this.empty = false;
            return this;
        }

        @NotNull
        private QualifierBuilder _getOrCreateNestedQualifierBuilder(LogicalOp newOp) {
            this._closeNestedQualifier();
            this._appendDelimiterIfNecessary();
            this.nestedQualifierBuilder = new QualifierBuilder(newOp);
            return this.nestedQualifierBuilder;
        }

        private void _closeNestedQualifier() {
            if (this.nestedQualifierBuilder != null) {
                this.nestedQualifierBuilder.close();
                this.nestedQualifierBuilder = null;
            }
        }

        public QualifierBuilder or() {
            return this._getOrCreateNestedQualifierBuilder(LogicalOp.or);
        }

        public QualifierBuilder and() {
            return this._getOrCreateNestedQualifierBuilder(LogicalOp.and);
        }

        private void close() {
            this._closeNestedQualifier();
            if (this.delim != null) {
                SQLQueryBuilder.this.sql.append(")");
            }
        }
    }
}

