/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.database;

import com.prosc.database.StreamBlob;
import com.prosc.database.UrlBlob;
import com.prosc.io.FileType;
import com.prosc.io.FileTypes;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlobAndMetaData2
implements Blob {
    private static final Logger log = Logger.getLogger(BlobAndMetaData2.class.getName());
    @NotNull
    private final Blob delegate;
    private String filename;
    private String _md5hash;
    private boolean didFree = false;

    public BlobAndMetaData2(@NotNull Blob blob, @Nullable String filename, @Nullable String md5Hash) {
        this.delegate = blob;
        this.filename = filename;
        this._md5hash = md5Hash;
    }

    public String getFilename() {
        block10: {
            if (this.filename == null || !this.filename.contains(".")) {
                if (this.filename == null) {
                    this.filename = "Untitled";
                }
                try {
                    InputStream beginningStream;
                    if (this.delegate.length() <= 0L) break block10;
                    log.info("BLOB is missing a filename or suffix; will read the first 1K of data to guess its type");
                    try {
                        beginningStream = this.delegate.getBinaryStream(1L, 1024L);
                    }
                    catch (SQLException e) {
                        beginningStream = this.delegate.getBinaryStream();
                    }
                    try {
                        FileType fileType = FileTypes.guessTypeFromContents(beginningStream);
                        this.filename = this.filename + "." + fileType.getPrimaryExtension();
                        log.info("Guessed file name is " + this.filename);
                    }
                    finally {
                        beginningStream.close();
                    }
                }
                catch (SQLException e) {
                    log.log(Level.WARNING, "Could not get BLOB stream to determine filename", e);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Error reading BLOB data to determine filename", e);
                }
            }
        }
        return this.filename;
    }

    public int hashCode() {
        return this.getMd5Hash().hashCode();
    }

    public synchronized String getMd5Hash() {
        block20: {
            if (this._md5hash == null) {
                try {
                    if (this.delegate instanceof UrlBlob) {
                        this._md5hash = ((UrlBlob)this.delegate).getMd5hash();
                    } else if (this.delegate instanceof StreamBlob) {
                        this._md5hash = ((StreamBlob)this.delegate).getMD5();
                    }
                    if (this._md5hash != null) break block20;
                    if (this.delegate.length() == 0L) {
                        this._md5hash = "";
                        break block20;
                    }
                    log.log(Level.FINE, "Calculating MD5 for " + this.toString() + "; length " + this.delegate.length());
                    try (InputStream stream = this.delegate.getBinaryStream();){
                        this._md5hash = BlobAndMetaData2.generateMd5(stream);
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException | SQLException e) {
                    log.log(Level.WARNING, "Could not calculate MD5 hash for " + this, e);
                    this._md5hash = "";
                }
            }
        }
        return this._md5hash;
    }

    public static String generateMd5(InputStream stream) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        try (DigestInputStream dis = new DigestInputStream(stream, md);){
            byte[] buffer = new byte[8192];
            while (dis.read(buffer) != -1) {
            }
            byte[] digest = md.digest();
            StringBuilder tmpHash = new StringBuilder();
            for (byte eachByte : digest) {
                tmpHash.append(Integer.toString((eachByte & 0xFF) + 256, 16).substring(1));
            }
            String string = tmpHash.toString();
            return string;
        }
    }

    public String toString() {
        if (this.filename == null) {
            return "Untitled binary object " + this.delegate.hashCode();
        }
        return "Binary object '" + this.filename + "'";
    }

    public String toAuditableString() {
        String tmpHash = this.getMd5Hash();
        if (StringUtils.isEmpty(tmpHash)) {
            return "[Empty]";
        }
        return this.getFilename() + " (" + tmpHash.toUpperCase() + ")";
    }

    @Override
    public long length() throws SQLException {
        return this.delegate.length();
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        return this.delegate.getBytes(pos, length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.delegate.getBinaryStream();
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        return this.delegate.position(pattern, start);
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.delegate.position(pattern, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        BlobAndMetaData2 blobAndMetaData2 = this;
        synchronized (blobAndMetaData2) {
            this._md5hash = null;
        }
        return this.delegate.setBytes(pos, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        BlobAndMetaData2 blobAndMetaData2 = this;
        synchronized (blobAndMetaData2) {
            this._md5hash = null;
        }
        return this.delegate.setBytes(pos, bytes, offset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        BlobAndMetaData2 blobAndMetaData2 = this;
        synchronized (blobAndMetaData2) {
            this._md5hash = null;
        }
        return this.delegate.setBinaryStream(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long len) throws SQLException {
        BlobAndMetaData2 blobAndMetaData2 = this;
        synchronized (blobAndMetaData2) {
            this._md5hash = null;
        }
        this.delegate.truncate(len);
    }

    @Override
    public void free() throws SQLException {
        if (this.didFree) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "This BLOB has already had free() called on it: " + this, new RuntimeException("Stack trace only"));
            }
        } else {
            try {
                this.getMd5Hash();
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "Could not generate MD5 hash in free(). Will continue with the rest of the free() implementation. " + this, t);
            }
            finally {
                this.delegate.free();
                this.didFree = true;
            }
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return this.delegate.getBinaryStream(pos, length);
    }
}

