/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.core;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeedbackException
extends Exception {
    private static final Logger log = Logger.getLogger(FeedbackException.class.getName());
    private String bundleKey;
    private transient ResourceBundle resourceBundle;

    public FeedbackException(String message) {
        super(message);
    }

    public FeedbackException(String message, String bundleKey) {
        super(message);
        this.bundleKey = bundleKey;
    }

    public FeedbackException(Throwable cause) {
        super(cause instanceof RuntimeException || cause instanceof Error ? cause.toString() : cause.getLocalizedMessage(), cause);
    }

    public FeedbackException(String message, Throwable cause) {
        super(message, cause);
    }

    public FeedbackException(String message, String bundleKey, Throwable cause) {
        super(message, cause);
        this.bundleKey = bundleKey;
    }

    @Override
    public String toString() {
        return this.getLocalizedMessage();
    }

    @Override
    public String getLocalizedMessage() {
        if (this.bundleKey != null) {
            try {
                return this.getResourceBundle().getString(this.bundleKey);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to translate " + this.bundleKey, e);
            }
        }
        return super.getLocalizedMessage();
    }

    protected ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            String baseName = System.getProperty("com.prosc.resourceBundle", "com.prosc.strings");
            this.resourceBundle = ResourceBundle.getBundle(baseName);
        }
        return this.resourceBundle;
    }
}

