/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;

public class ExceptionCoreUtils {
    private static final Logger log = Logger.getLogger(ExceptionCoreUtils.class.getName());

    public static RuntimeException rethrowUnchecked(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    private static void appendCurrentStackTrace(Throwable cause) {
        StackTraceElement[] stack1 = cause.getStackTrace();
        StackTraceElement[] stack2 = new RuntimeException().getStackTrace();
        stack2[0] = new StackTraceElement(stack2[0].getClassName(), "=== Appending stack trace of current thread ===", stack2[0].getFileName(), stack2[0].getLineNumber());
        ArrayList combinedStack = new ArrayList(stack1.length + stack2.length);
        Collections.addAll(combinedStack, stack1);
        Collections.addAll(combinedStack, stack2);
        StackTraceElement[] combinedStackArray = combinedStack.toArray(new StackTraceElement[0]);
        cause.setStackTrace(combinedStackArray);
    }

    public static <E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> E1 rethrowTypeSafeException(Throwable e, Class<E1> exceptionClass1, Class<E2> exceptionClass2, Class<E3> exceptionClass3, Class<E4> exceptionClass4, Class<E5> exceptionClass5, Class<E6> exceptionClass6) throws E1, E2, E3, E4, E5, E6 {
        if (exceptionClass1.isAssignableFrom(e.getClass())) {
            ExceptionCoreUtils.appendCurrentStackTrace(e);
            throw e;
        }
        if (exceptionClass2.isAssignableFrom(e.getClass())) {
            ExceptionCoreUtils.appendCurrentStackTrace(e);
            throw e;
        }
        if (exceptionClass3.isAssignableFrom(e.getClass())) {
            ExceptionCoreUtils.appendCurrentStackTrace(e);
            throw e;
        }
        if (exceptionClass4.isAssignableFrom(e.getClass())) {
            ExceptionCoreUtils.appendCurrentStackTrace(e);
            throw e;
        }
        if (exceptionClass5.isAssignableFrom(e.getClass())) {
            ExceptionCoreUtils.appendCurrentStackTrace(e);
            throw e;
        }
        if (exceptionClass6.isAssignableFrom(e.getClass())) {
            ExceptionCoreUtils.appendCurrentStackTrace(e);
            throw e;
        }
        if (e instanceof Error) {
            ExceptionCoreUtils.appendCurrentStackTrace(e);
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            ExceptionCoreUtils.appendCurrentStackTrace(e);
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static <E1 extends Throwable> E1 rethrowTypeSafeException(Throwable e, Class<E1> exceptionClass1) throws E1 {
        return ExceptionCoreUtils.rethrowTypeSafeException(e, exceptionClass1, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }
}

