/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sqs.util;

import com.prosc.aws.Signer;
import com.prosc.aws.exception.AWSRuntimeException;
import com.prosc.aws.sqs.Message;
import com.prosc.aws.sqs.ReceiveMessage;
import com.prosc.thread.MyThreadFactory;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageCollector {
    private static final Logger log = Logger.getLogger(MessageCollector.class.getName());
    private final BlockingQueue<Message> queue;
    private final int threadCount;
    private final Signer _signer;
    private final boolean encrypt;
    private final String queueUrl;
    private final Map<String, ?> dupeCheck;
    private ExecutorService threadPool = null;
    private boolean keepRunning = true;

    public MessageCollector(BlockingQueue<Message> queue, int threadCount, final int dupeCheckSize, @Nullable Signer signer, boolean encrypt, @NotNull String queueUrl) {
        this.threadCount = threadCount;
        String queuName = queueUrl.substring(queueUrl.lastIndexOf(47) + 1);
        this.threadPool = Executors.newFixedThreadPool(threadCount, new MyThreadFactory("MessageCollector for " + queuName));
        this.queue = queue;
        this.dupeCheck = new LinkedHashMap<String, Object>(dupeCheckSize){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
                return this.size() > dupeCheckSize;
            }
        };
        this._signer = signer;
        this.encrypt = encrypt;
        this.queueUrl = queueUrl;
    }

    public BlockingQueue<Message> getQueue() {
        return this.queue;
    }

    private Signer getSigner() throws IOException {
        if (this._signer == null) {
            return Signer.getSignerForRole();
        }
        return this._signer;
    }

    public void start() {
        if (this.threadPool == null) {
            throw new IllegalStateException("shutdown() has already been called.");
        }
        for (int n = 0; n < this.threadCount; ++n) {
            this.threadPool.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            try {
                                List<Message> messageList = new ReceiveMessage(MessageCollector.this.getSigner(), MessageCollector.this.encrypt, MessageCollector.this.queueUrl).setMaxNumberOfMessages(10).setWaitTimeSeconds(20).call();
                                Map map = MessageCollector.this.dupeCheck;
                                synchronized (map) {
                                    for (Message message : messageList) {
                                        String messageId = message.getMessageId();
                                        if (MessageCollector.this.dupeCheck.containsKey(messageId)) {
                                            log.log(Level.WARNING, "Received messageId '" + messageId + "' more than once; will skip it. Message contents:\n" + message.toString());
                                            continue;
                                        }
                                        MessageCollector.this.dupeCheck.put(messageId, null);
                                        MessageCollector.this.queue.put(message);
                                    }
                                }
                            }
                            catch (IOException e) {
                                log.log(Level.SEVERE, "IOException occurred while fetching from queue " + MessageCollector.this.queueUrl, e);
                                Thread.sleep(20000L);
                            }
                            catch (AWSRuntimeException e) {
                                log.log(Level.SEVERE, "AWSRuntimeException occurred while fetching from queue " + MessageCollector.this.queueUrl, e);
                                Thread.sleep(20000L);
                            }
                            MessageCollector e = MessageCollector.this;
                            synchronized (e) {
                                if (!MessageCollector.this.keepRunning) {
                                    return;
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        log.log(Level.WARNING, "MessageCollector thread was interrupted; exiting: " + MessageCollector.this.toString());
                    }
                }
            });
        }
    }

    public void shutdown() {
        this.shutdown(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean interrupt, boolean waitForShutdown) {
        if (this.threadPool != null) {
            MessageCollector messageCollector = this;
            synchronized (messageCollector) {
                this.keepRunning = false;
            }
            if (interrupt) {
                this.threadPool.shutdownNow();
            } else {
                this.threadPool.shutdown();
            }
            if (waitForShutdown) {
                try {
                    this.threadPool.awaitTermination(30L, TimeUnit.SECONDS);
                    this.threadPool = null;
                }
                catch (InterruptedException e) {
                    log.log(Level.WARNING, "Interrupted during 30 second wait period to shut down this collector: " + this, e);
                }
            }
        }
    }

    public String toString() {
        return "MessageCollector{queueUrl='" + this.queueUrl + '\'' + ", threadCount=" + this.threadCount + '}';
    }
}

