/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sqs;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.AwsResult;
import com.prosc.aws.ResponseStyle;
import com.prosc.aws.Signer;
import com.prosc.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

abstract class SQSRequest
extends AwsRequest<SQSRequest> {
    private final boolean encrypt;
    private final String queueUrl;

    public SQSRequest(Signer signer, boolean encrypt) {
        this(signer, encrypt, null);
    }

    public SQSRequest(@Nullable Signer signer, boolean encrypt, String queueUrl) {
        super(signer);
        this.setQueryParam("Version", "2012-11-05");
        this.encrypt = encrypt;
        this.queueUrl = queueUrl;
    }

    @Override
    protected final AwsResult _send(String nextToken) throws IOException {
        URL endpoint = this.queueUrl == null ? IOUtils.toUrl((this.encrypt ? "https" : "http") + "://sqs." + this.getRegion().code + ".amazonaws.com/") : new URL(this.queueUrl);
        HttpURLConnection connection = (HttpURLConnection)endpoint.openConnection();
        connection.setConnectTimeout(25000);
        connection.setReadTimeout(25000);
        connection.setUseCaches(false);
        connection.setRequestMethod("POST");
        String payload = IOUtils.urlEncodeMap(this.getAllParams());
        connection.setFixedLengthStreamingMode(payload.length());
        if (this.getSigner() != null) {
            this.getSigner().signRequestV4(connection, this.getRegion(), "sqs", this, this.getQueryParams(), new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8)));
        }
        IOUtils.postDataToUrlConnection(payload, connection);
        return new AwsResult(connection, ResponseStyle.xml, this).download();
    }

    @Override
    public String toString() {
        return super.toString() + ", queueUrl=" + this.queueUrl;
    }
}

