/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sqs;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.sqs.Message;
import com.prosc.aws.sqs.SQSRequest;
import com.prosc.thread.MyThreadFactory;
import com.prosc.thread.ThreadUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReceiveMessage
extends SQSRequest {
    private boolean noWait = false;
    private static volatile ExecutorService downloadQueue;

    public ReceiveMessage(Signer signer, boolean encrypt, @NotNull String queueUrl) {
        super(signer, encrypt, queueUrl);
        this.setQueryParam("Action", "ReceiveMessage");
        this.setQueryParam("AttributeName", "All");
        this.setQueryParam("MessageAttributeName", "All");
    }

    public ReceiveMessage setMaxNumberOfMessages(int maxNumberOfMessages) {
        if (maxNumberOfMessages < 1 || maxNumberOfMessages > 10) {
            throw new IllegalArgumentException("MaxNumberOfMessages must be between 1 and 10; called with " + maxNumberOfMessages);
        }
        this.setQueryParam("MaxNumberOfMessages", String.valueOf(maxNumberOfMessages));
        return this;
    }

    public ReceiveMessage setVisibilityTimeout(int visibilityTimeoutSeconds) {
        this.noWait = visibilityTimeoutSeconds == 0;
        this.setQueryParam("VisibilityTimeout", String.valueOf(visibilityTimeoutSeconds));
        return this;
    }

    public ReceiveMessage setWaitTimeSeconds(int waitTimeSeconds) {
        this.setQueryParam("WaitTimeSeconds", String.valueOf(waitTimeSeconds));
        return this;
    }

    public static void shutdown() {
        downloadQueue.shutdown();
        try {
            downloadQueue.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public List<Message> call() throws IOException, InterruptedException {
        Callable<List<Message>> callable = new Callable<List<Message>>(){

            @Override
            public List<Message> call() throws IOException {
                AwsResult awsResult = ReceiveMessage.this.sendWithRetry();
                awsResult.validate();
                NodeList messages = awsResult.getDocument().getElementsByTagName("Message");
                ArrayList<Message> result = new ArrayList<Message>(messages.getLength());
                for (int n = 0; n < messages.getLength(); ++n) {
                    Element messageElement = (Element)messages.item(n);
                    result.add(new Message(messageElement));
                }
                return result;
            }
        };
        if (this.noWait) {
            try {
                return (List)callable.call();
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (downloadQueue == null) {
            MyThreadFactory threadFactory = new MyThreadFactory("Interruptible ReceiveMessage"){

                @Override
                public Thread newThread(@NotNull Runnable r) {
                    Thread result = super.newThread(r);
                    result.setDaemon(true);
                    return result;
                }
            };
            downloadQueue = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        }
        return ThreadUtil.getInterruptible(downloadQueue.submit(callable), IOException.class);
    }
}

