/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sqs;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.QueueAlreadyExistsException;
import com.prosc.aws.sqs.SQSRequest;
import java.io.IOException;

public class CreateQueue
extends SQSRequest {
    public CreateQueue(Signer signer, boolean encrypt, String queueName) {
        super(signer, encrypt);
        this.setQueryParam("Action", "CreateQueue");
        this.setQueryParam("QueueName", queueName);
    }

    public CreateQueue setDelaySeconds(int delaySeconds) {
        this.setQueryParam("Attribute.1.Name", "DelaySeconds");
        this.setQueryParam("Attribute.1.Value", String.valueOf(delaySeconds));
        return this;
    }

    public CreateQueue setMaximumMessageSize(int maximumMessageSize) {
        this.setQueryParam("Attribute.1.Name", "MaximumMessageSize");
        this.setQueryParam("Attribute.1.Value", String.valueOf(maximumMessageSize));
        return this;
    }

    public CreateQueue setMessageRetentionPeriodSeconds(int messageRetentionPeriod) {
        this.setQueryParam("Attribute.1.Name", "MessageRetentionPeriod");
        this.setQueryParam("Attribute.1.Value", String.valueOf(messageRetentionPeriod));
        return this;
    }

    public CreateQueue setPolicy(String policyDocument) {
        this.setQueryParam("Attribute.1.Name", "Policy");
        this.setPostParam("Attribute.1.Value", policyDocument);
        return this;
    }

    public CreateQueue setReceiveMessageWaitTimeSeconds(int receiveMessageWaitTimeSeconds) {
        this.setQueryParam("Attribute.1.Name", "ReceiveMessageWaitTimeSeconds");
        this.setQueryParam("Attribute.1.Value", String.valueOf(receiveMessageWaitTimeSeconds));
        return this;
    }

    public CreateQueue setVisibilityTimeoutSeconds(int visibilityTimeount) {
        this.setQueryParam("Attribute.1.Name", "VisibilityTimeout");
        this.setQueryParam("Attribute.1.Value", String.valueOf(visibilityTimeount));
        return this;
    }

    public String call() throws IOException, QueueAlreadyExistsException {
        AwsResult awsResult = this.sendWithRetry();
        QueueAlreadyExistsException.check(awsResult);
        awsResult.validate();
        return awsResult.getDocument().getElementsByTagName("QueueUrl").item(0).getTextContent();
    }
}

