/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.NoSuchEntityException;
import com.prosc.aws.iam.IamRequest;
import java.io.IOException;

public class UpdateAccessKeyRequest
extends IamRequest {
    public UpdateAccessKeyRequest(Signer signer, String accessKeyId, Status newStatus) {
        super(signer);
        this.setQueryParam("Action", "UpdateAccessKey");
        this.setQueryParam("AccessKeyId", accessKeyId);
        this.setQueryParam("Status", newStatus.name());
    }

    public UpdateAccessKeyRequest setUserName(String userName) {
        this.setQueryParam("UserName", userName);
        return this;
    }

    public void call() throws IOException, NoSuchEntityException {
        AwsResult awsResult = this.sendWithRetry();
        NoSuchEntityException.check(awsResult);
        this.validate(awsResult);
        awsResult.validate();
    }

    public static enum Status {
        Active,
        Inactive;

    }
}

