/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.Signer;
import com.prosc.xml.DomUtils;
import java.util.Date;
import org.w3c.dom.Element;

public class Policy {
    private final String policyName;
    private final String defaultVersionId;
    private final String policyId;
    private final String path;
    private final String arn;
    private final Integer attachmentCount;
    private final Date createDate;
    private final Date updateDate;

    Policy(Element xml) {
        this.policyName = DomUtils.getChildText(xml, "PolicyName");
        this.defaultVersionId = DomUtils.getChildText(xml, "DefaultVersionId");
        this.policyId = DomUtils.getChildText(xml, "PolicyId");
        this.path = DomUtils.getChildText(xml, "Path");
        this.arn = DomUtils.getChildText(xml, "Arn");
        this.attachmentCount = Integer.valueOf(DomUtils.getChildText(xml, "AttachmentCount"));
        this.createDate = Signer.parseDateTime(DomUtils.getChildText(xml, "CreateDate"));
        this.updateDate = Signer.parseDateTime(DomUtils.getChildText(xml, "UpdateDate"));
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getDefaultVersionId() {
        return this.defaultVersionId;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getPath() {
        return this.path;
    }

    public String getArn() {
        return this.arn;
    }

    public Integer getAttachmentCount() {
        return this.attachmentCount;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public String toString() {
        return "Policy{policyName='" + this.policyName + '\'' + ", defaultVersionId='" + this.defaultVersionId + '\'' + ", policyId='" + this.policyId + '\'' + ", path='" + this.path + '\'' + ", arn='" + this.arn + '\'' + ", attachmentCount=" + this.attachmentCount + ", createDate=" + this.createDate + ", updateDate=" + this.updateDate + '}';
    }

    public static String nameToArn(String awsAccountId, String policyName) {
        return "arn:aws:iam::" + awsAccountId + ":policy/" + policyName;
    }
}

