/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.AwsResult;
import com.prosc.aws.Region;
import com.prosc.aws.ResponseStyle;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.EntityAlreadyExistsException;
import com.prosc.aws.iam.IamConstants;
import com.prosc.io.IOUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public abstract class IamRequest
extends AwsRequest<IamRequest> {
    public IamRequest(@NotNull Signer signer) {
        super(signer);
        this.setQueryParam("Version", "2010-05-08");
    }

    protected void validate(AwsResult awsResult) {
        EntityAlreadyExistsException.check(awsResult, this);
    }

    @Override
    protected final AwsResult _send(String nextToken) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)IamConstants.IAM_ENDPOINT.openConnection();
        connection.setUseCaches(false);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        if (this.getSigner() == null) {
            throw new IllegalStateException("Signer must not be null");
        }
        String postData = IOUtils.urlEncodeMap(this.getAllParams());
        this.getSigner().signRequestV4(connection, Region.usEast1, "iam", this, postData.getBytes(StandardCharsets.UTF_8));
        IOUtils.postDataToUrlConnection(postData, connection);
        return new AwsResult(connection, ResponseStyle.xml, this).download();
    }
}

