/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.NoSuchEntityException;
import com.prosc.aws.iam.IamRequest;
import com.prosc.aws.iam.Role;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class GetRoleRequest
extends IamRequest {
    public GetRoleRequest(@NotNull Signer signer, @NotNull String roleName) {
        super(signer);
        this.setQueryParam("Action", "GetRole");
        this.setQueryParam("RoleName", roleName);
    }

    public Role call() throws IOException, NoSuchEntityException {
        AwsResult awsResult = this.sendWithRetry();
        NoSuchEntityException.check(awsResult);
        this.validate(awsResult);
        awsResult.validate();
        Element xml = (Element)awsResult.getDocument().getElementsByTagName("Role").item(0);
        return new Role(xml);
    }
}

