/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.format.UTCTimestampFormat;
import com.prosc.xml.DomUtils;
import java.util.Date;
import org.w3c.dom.Element;

public class Credentials {
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final Date expirationDate;

    public Credentials(Element credentials) {
        this.accessKeyId = DomUtils.getChildText(credentials, "AccessKeyId");
        this.secretAccessKey = DomUtils.getChildText(credentials, "SecretAccessKey");
        this.sessionToken = DomUtils.getChildText(credentials, "SessionToken");
        String expirationString = DomUtils.getChildText(credentials, "Expiration");
        this.expirationDate = new UTCTimestampFormat().parse(expirationString);
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String toString() {
        return "Credentials{accessKeyId='" + this.accessKeyId + '\'' + ", expirationDate=" + this.expirationDate + '}';
    }
}

