/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.iam.IamRequest;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateRoleRequest
extends IamRequest {
    public CreateRoleRequest(@NotNull Signer signer, @NotNull String roleName, @Nullable String path) {
        super(signer);
        this.setQueryParam("Action", "CreateRole");
        this.setQueryParam("RoleName", roleName);
        if (path != null) {
            this.setQueryParam("Path", path);
        }
        String assumeRolePolicyDocument = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"Service\":[\"ec2.amazonaws.com\"]},\"Action\":[\"sts:AssumeRole\"]}]}";
        this.setPostParam("AssumeRolePolicyDocument", assumeRolePolicyDocument);
    }

    public void call() throws IOException {
        AwsResult awsResult = this.sendWithRetry();
        this.validate(awsResult);
        awsResult.validate();
    }
}

