/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.iam.IamRequest;
import com.prosc.aws.iam.Policy;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class CreatePolicyRequest
extends IamRequest {
    public CreatePolicyRequest(@NotNull Signer signer, @NotNull String policyName, @NotNull String policyDocument) {
        super(signer);
        this.setPostParam("Action", "CreatePolicy");
        this.setQueryParam("PolicyName", policyName);
        this.setPostParam("PolicyDocument", policyDocument);
    }

    public CreatePolicyRequest setPath(String path) {
        this.setQueryParam("Path", path);
        return this;
    }

    public CreatePolicyRequest setDescription(String description) {
        this.setQueryParam("Description", description);
        return this;
    }

    public Policy call() throws IOException {
        AwsResult awsResult = this.sendWithRetry();
        this.validate(awsResult);
        awsResult.validate();
        Element policyElement = (Element)awsResult.getDocument().getElementsByTagName("Policy").item(0);
        return new Policy(policyElement);
    }
}

