/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.exception;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.AwsResult;
import com.prosc.aws.exception.AWSRuntimeException;
import com.prosc.xml.DomUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServerClockMismatchException
extends AWSRuntimeException {
    private static final Logger log = Logger.getLogger(ServerClockMismatchException.class.getName());

    public ServerClockMismatchException(int responseCode, Document parsedXml, AwsRequest<?> request) {
        super(responseCode, parsedXml, request);
        Element xml = parsedXml.getDocumentElement();
        String maxAllowedSkewMillisecondsString = DomUtils.getChildText(xml, "MaxAllowedSkewMilliseconds");
        if (maxAllowedSkewMillisecondsString == null) {
            this.setMessage(DomUtils.getRecursiveChildText(xml, "Message"));
        } else {
            int maxMilliseconds = Integer.parseInt(maxAllowedSkewMillisecondsString);
            String serverTimeString = DomUtils.getChildText(xml, "ServerTime");
            String requestTimeString = DomUtils.getChildText(xml, "RequestTime");
            int maxMinutes = maxMilliseconds / 60000;
            String newMessage = "The clock on this server is more than " + maxMinutes + " minutes off. This must be corrected before any Amazon Web Services will function.";
            try {
                Date serverDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US).parse(serverTimeString.replaceAll("Z$", "+0000"));
                Date requestTime = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.US).parse(requestTimeString);
                newMessage = newMessage + " Correct time is currently " + serverDate + "; your clock is set to " + requestTime;
            }
            catch (ParseException e1) {
                log.log(Level.WARNING, "Could not parse server time from " + serverTimeString);
            }
            this.setMessage(newMessage);
        }
    }

    public static void check(AwsResult awsResult, AwsRequest<?> request) {
        if ("RequestTimeTooSkewed".equals(awsResult.getErrorCode())) {
            throw new ServerClockMismatchException(awsResult.getHttpStatusCode(), awsResult.getDocument(), request);
        }
    }
}

