/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.exception;

import com.prosc.aws.AwsResult;
import com.prosc.aws.exception.AWSException;
import com.prosc.xml.DomUtils;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SESException
extends AWSException {
    private String type;
    private String code;

    public SESException(int responseCode, Document parsedXml) {
        super(responseCode, parsedXml);
    }

    public SESException(String errorMessage, Document parsedXml) {
        super(errorMessage, parsedXml);
    }

    public SESException(String errorMessage, String type, String code, Document parsedXml) {
        super(errorMessage, parsedXml);
        this.type = type;
        this.code = code;
    }

    public static void check(AwsResult awsResult) throws SESException {
        Iterator<Element> errors = DomUtils.getChildElements((Node)awsResult.getDocument(), "ErrorResponse").iterator();
        if (errors.hasNext()) {
            Element errorResponse = errors.next();
            Element error = DomUtils.getChildElements((Node)errorResponse, "Error").iterator().next();
            throw new SESException(DomUtils.getChildText(error, "Message"), DomUtils.getChildText(error, "Type"), DomUtils.getChildText(error, "Code"), awsResult.getDocument());
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        return "SESException{type='" + this.type + '\'' + ", code='" + this.code + '\'' + "} " + super.toString();
    }
}

