/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.exception;

import com.prosc.aws.AwsResult;
import com.prosc.aws.exception.SESException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MessageRejectedException
extends SESException {
    public MessageRejectedException(int responseCode, Document parsedXml) {
        super(responseCode, parsedXml);
    }

    public MessageRejectedException(String errorMessage, Document parsedXml) {
        super(errorMessage, parsedXml);
    }

    public static void check(AwsResult awsResult, String source) throws MessageRejectedException {
        if ("MessageRejected".equals(awsResult.getErrorCode())) {
            NodeList messages = awsResult.getDocument().getElementsByTagName("Message");
            String unverifiedMessage = "Email address is not verified.";
            if (messages.getLength() == 1 && unverifiedMessage.equals(messages.item(0).getTextContent())) {
                throw new MessageRejectedException("Email address is not verified: '" + source + "'", awsResult.getDocument());
            }
            throw new MessageRejectedException(awsResult.getHttpStatusCode(), awsResult.getDocument());
        }
    }
}

