/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.exception;

import com.prosc.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AWSException
extends Exception {
    private String message;
    private final String type;
    private final String code;
    private final String requestId;
    private final Integer responseCode;
    private final Document parsedXml;

    public AWSException(String errorMessage) {
        this(errorMessage, (Document)null);
    }

    public AWSException(String errorMessage, Document parsedXml) {
        this.message = errorMessage;
        this.type = null;
        this.code = null;
        this.requestId = null;
        this.responseCode = null;
        this.parsedXml = parsedXml;
    }

    public AWSException(int responseCode, Document parsedXml) {
        Element xml = parsedXml.getDocumentElement();
        this.code = DomUtils.getRecursiveChildText(xml, "Code");
        this.type = DomUtils.getRecursiveChildText(xml, "Type");
        this.message = DomUtils.getRecursiveChildText(xml, "Message");
        this.requestId = DomUtils.getRecursiveChildText(xml, "RequestId");
        this.responseCode = responseCode;
        this.parsedXml = parsedXml;
    }

    public boolean shouldRetry() {
        return false;
    }

    @Override
    public String getMessage() {
        if (this.getClass() == AWSException.class && this.parsedXml != null) {
            return this.getXmlResponse();
        }
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public String getCode() {
        return this.code;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getXmlResponse() {
        if (this.parsedXml == null) {
            return null;
        }
        return DomUtils.dumpXml(this.parsedXml, null);
    }

    public int getResponseCode() {
        return this.responseCode;
    }
}

