/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws;

import com.prosc.data.tuple.Pair;
import com.prosc.io.IOUtils;
import com.prosc.shared.DebugTimer;
import com.prosc.thread.MyThreadFactory;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Region {
    usEast1("us-east-1", "Virginia"),
    usEast2("us-east-2", "Ohio"),
    usWest1("us-west-1", "California"),
    usWest2("us-west-2", "Oregon"),
    afSouth1("af-south-1", "Cape Town"),
    apEast1("ap-east-1", "Hong Kong"),
    apSouth1("ap-south-1", "Mumbai"),
    apNortheast1("ap-northeast-1", "Tokyo"),
    apNortheast2("ap-northeast-2", "Seoul"),
    apNortheast3("ap-northeast-3", "Osaka-Local"),
    apSoutheast1("ap-southeast-1", "Singapore"),
    apSoutheast2("ap-southeast-2", "Sydney"),
    caCentral1("ca-central-1", "Toronto"),
    cnNorth1("cn-north-1", "Beijing"),
    cnNorthwest1("cn-northwest-1", "China (Ningxia)"),
    euCentral1("eu-central-1", "Frankfurt"),
    euSouth1("eu-south-1", "Milan"),
    euWest1("eu-west-1", "Ireland"),
    euWest2("eu-west-2", "London"),
    euWest3("eu-west-3", "Paris"),
    euNorth1("eu-north-1", "Stockholm"),
    meSouth1("me-south-1", "Middle East (Bahrain)"),
    saEast1("sa-east-1", "S\u00e3o Paulo");

    private static final Logger log;
    public final String code;
    public final String location;

    private Region(String code, String location) {
        this.code = code;
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public static List<Region> getRegionsByLatency(int testCount, @Nullable Integer maxWaitTime, boolean onlyFastest, boolean detailedLogging) throws InterruptedException {
        timeout = maxWaitTime == null ? 0x7FFFFFFF : maxWaitTime;
        allRegions = Region.values();
        dt = new DebugTimer("Starting threads to check ping times to " + allRegions.length + " regions", detailedLogging);
        var7_7 = null;
        try {
            block24: {
                worker = Executors.newFixedThreadPool(allRegions.length, new MyThreadFactory("getRegionsByLatency"));
                try {
                    checks = Arrays.stream(allRegions).map((Function<Region, Callable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getRegionsByLatency$1(com.prosc.shared.DebugTimer int com.prosc.aws.Region ), (Lcom/prosc/aws/Region;)Ljava/util/concurrent/Callable;)((DebugTimer)dt, (int)testCount)).collect(Collectors.toList());
                    if (!onlyFastest) break block24;
                    try {
                        result = Collections.singletonList(worker.invokeAny(checks, timeout, TimeUnit.MILLISECONDS));
                        Region.log.info("Ping time for fastest region (" + ((Pair)result.get((int)0)).a + ") is " + ((Pair)result.get((int)0)).b + " milliseconds");
                        ** GOTO lbl44
                    }
                    catch (Exception e) {
                        Region.log.log(Level.WARNING, "Could not establish a successful connection to any region", e);
                        var12_14 = Collections.emptyList();
                        worker.shutdownNow();
                        if (dt != null) {
                            if (var7_7 != null) {
                                try {
                                    dt.close();
                                }
                                catch (Throwable var13_16) {
                                    var7_7.addSuppressed(var13_16);
                                }
                            } else {
                                dt.close();
                            }
                        }
                        return var12_14;
                    }
                }
                catch (Throwable var14_17) {
                    try {
                        worker.shutdownNow();
                        throw var14_17;
                    }
                    catch (Throwable var8_9) {
                        var7_7 = var8_9;
                        throw var8_9;
                    }
                }
            }
            futures = worker.invokeAll(checks);
            result = futures.stream().map((Function<Future, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getRegionsByLatency$2(int java.util.concurrent.Future ), (Ljava/util/concurrent/Future;)Lcom/prosc/data/tuple/Pair;)((int)timeout)).filter((Predicate<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lcom/prosc/data/tuple/Pair;)Z)()).sorted(Comparator.comparingLong((ToLongFunction<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, lambda$getRegionsByLatency$3(com.prosc.data.tuple.Pair ), (Lcom/prosc/data/tuple/Pair;)J)())).collect(Collectors.toList());
lbl44:
            // 2 sources

            var11_13 = result.stream().map((Function<Pair, Region>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getRegionsByLatency$4(com.prosc.data.tuple.Pair ), (Lcom/prosc/data/tuple/Pair;)Lcom/prosc/aws/Region;)()).collect(Collectors.toList());
            worker.shutdownNow();
            return var11_13;
        }
        finally {
            if (dt != null) {
                if (var7_7 != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable var16_19) {
                        var7_7.addSuppressed(var16_19);
                    }
                } else {
                    dt.close();
                }
            }
        }
    }

    public static Region getRegionByCode(String code) {
        if (code == null) {
            return usEast1;
        }
        for (Region region : Region.values()) {
            if (!code.equals(region.code)) continue;
            return region;
        }
        throw new IllegalArgumentException("No region found for code: " + code + ".  Valid values are:\n" + Region.getRegionCodes());
    }

    public static String getRegionCodes() {
        return Arrays.stream(Region.values()).map(Region::getCode).collect(Collectors.joining("\n"));
    }

    public String getCode() {
        return this.code;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return this.location;
    }

    private static /* synthetic */ Region lambda$getRegionsByLatency$4(Pair pair) {
        return (Region)((Object)pair.a);
    }

    private static /* synthetic */ long lambda$getRegionsByLatency$3(Pair o) {
        return (Long)o.b;
    }

    private static /* synthetic */ Pair lambda$getRegionsByLatency$2(int timeout, Future future) {
        try {
            return (Pair)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    private static /* synthetic */ Callable lambda$getRegionsByLatency$1(DebugTimer dt, int testCount, Region region) {
        return () -> {
            int successCount = 0;
            long duration = 0L;
            URL testUrl = IOUtils.toUrl("http://ec2." + region.code + ".amazonaws.com");
            dt.markTime("Running " + testCount + " latency tests for " + region.code);
            IOException lastFailure = null;
            for (int n = 1; n <= testCount; ++n) {
                try {
                    HttpURLConnection connection = (HttpURLConnection)testUrl.openConnection();
                    connection.setRequestMethod("HEAD");
                    long startTime = System.currentTimeMillis();
                    connection.getResponseCode();
                    duration += System.currentTimeMillis() - startTime;
                    ++successCount;
                    continue;
                }
                catch (IOException e) {
                    lastFailure = new IOException("Failed to connect to region " + (Object)((Object)region), e);
                }
            }
            if (successCount > 0) {
                long averageLatency = duration / (long)successCount;
                return new Pair<Region, Long>(region, averageLatency);
            }
            if (lastFailure != null) {
                throw lastFailure;
            }
            throw new RuntimeException("successCount was 0, but lastFailure is null");
        };
    }

    static {
        log = Logger.getLogger(Region.class.getName());
    }
}

