/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws;

import com.prosc.aws.exception.SESException;
import com.prosc.infrastructure.LogUtils;
import com.prosc.thread.MyThreadFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jetbrains.annotations.Nullable;

public abstract class AwsLogHandler
extends Handler {
    private static final Logger log = Logger.getLogger(AwsLogHandler.class.getName());
    @Nullable
    private final ExecutorService sender;
    public static final String ipAddress;
    private static volatile boolean checkLogFilter;
    private Level mostSevereLevel = Level.ALL;
    private String subject = null;
    private final boolean autoflush;
    private final List<LogRecord> logRecords = new LinkedList<LogRecord>();
    private String contextInfo;
    private boolean crossedThreshold = false;
    private Level threshold = Level.ALL;

    public AwsLogHandler(boolean autoflush) {
        this(autoflush, true);
    }

    public AwsLogHandler(boolean autoflush, boolean asynchronous) {
        this.autoflush = autoflush;
        this.sender = asynchronous ? Executors.newSingleThreadExecutor(new MyThreadFactory("SES Log sender", true)) : null;
        this.setFormatter(new SimpleFormatter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() > this.mostSevereLevel.intValue()) {
            this.mostSevereLevel = record.getLevel();
        }
        if (!this.isLoggable(record)) {
            return;
        }
        this.customizeLogRecord(record);
        AwsLogHandler awsLogHandler = this;
        synchronized (awsLogHandler) {
            if (!this.crossedThreshold && record.getLevel().intValue() >= this.threshold.intValue()) {
                this.crossedThreshold = true;
            }
            this.logRecords.add(record);
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    private void customizeLogRecord(LogRecord record) {
        if (checkLogFilter) {
            try {
                String requestInfo = (String)Class.forName("com.prosc.infrastructure.LogFilter").getMethod("getRequestInfo", new Class[0]).invoke(null, new Object[0]);
                record.setParameters(new String[]{requestInfo});
            }
            catch (InvocationTargetException requestInfo) {
            }
            catch (Throwable e) {
                checkLogFilter = false;
            }
        }
    }

    @Override
    public void flush() {
        block6: {
            if (this.logRecords.isEmpty()) {
                return;
            }
            if (this.crossedThreshold) {
                System.out.println("did cross threshold");
                ArrayList<LogRecord> logRecordsCopy = new ArrayList<LogRecord>(this.logRecords);
                this.logRecords.clear();
                this.crossedThreshold = false;
                Runnable task = () -> {
                    try {
                        LogRecord firstRecord = (LogRecord)logRecordsCopy.get(0);
                        if (this.subject == null) {
                            String loggerName = firstRecord.getLoggerName();
                            if (loggerName == null) {
                                loggerName = firstRecord.getSourceClassName();
                            }
                            this.subject = "Log message from " + loggerName + " running on " + ipAddress;
                        }
                        StringBuilder sb = new StringBuilder();
                        if (this.contextInfo != null) {
                            sb.append(this.contextInfo + "\n\n");
                        }
                        Formatter formatter = this.getFormatter();
                        for (LogRecord record : logRecordsCopy) {
                            if (record.getParameters() != null) {
                                for (Object parameter : record.getParameters()) {
                                    sb.append(parameter).append('\n');
                                }
                            }
                            sb.append("\n").append(formatter.format(record));
                        }
                        this.publish(sb);
                    }
                    catch (Throwable t) {
                        String msg = "Could not send log message using Amazon SES";
                        System.err.println(msg);
                        t.printStackTrace();
                        log.log(Level.SEVERE, msg, t);
                    }
                };
                try {
                    if (this.sender == null) {
                        task.run();
                        break block6;
                    }
                    this.sender.submit(task);
                }
                catch (Exception e) {
                    System.err.println("Error when trying to submit EmailSESLogHandler job: " + e.toString());
                    e.printStackTrace();
                }
            } else {
                this.logRecords.clear();
            }
        }
    }

    protected abstract void publish(StringBuilder var1) throws IOException, SESException;

    @Override
    public void close() throws SecurityException {
        log.info("close() called on EmailSESLogHandler");
        this.flush();
        if (this.sender != null) {
            this.sender.shutdown();
            try {
                this.sender.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Level getMostSevereLevel() {
        return this.mostSevereLevel;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContextInfo(String contextInfo) {
        this.contextInfo = contextInfo;
    }

    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }

    public Level getThreshold() {
        return this.threshold;
    }

    public String getSubject() {
        return this.subject;
    }

    static {
        checkLogFilter = true;
        String _ipAddress = LogUtils.getExternalAddress(false);
        if ("<unknown>".equals(_ipAddress)) {
            try {
                _ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e1) {
                _ipAddress = "127.0.0.1";
                System.err.println("Could not get local IP address: " + e1.getMessage());
            }
        }
        ipAddress = _ipAddress;
    }
}

