/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.windows;

import com.prosc.io.IOUtils;
import com.prosc.windows.NoSuchRegistryEntryException;
import com.prosc.windows.WindowsRegistryAccessException;
import java.io.IOException;
import java.util.logging.Logger;

public final class WindowsRegistry {
    private static final Logger log = Logger.getLogger(WindowsRegistry.class.getName());

    public static String readRegistry(String location, String key) throws NoSuchRegistryEntryException, IOException {
        String command = "reg query \"" + location + "\" /v \"" + key + "\"";
        Process process = Runtime.getRuntime().exec(command);
        String rawResult = IOUtils.inputStreamAsString(process.getInputStream());
        log.info("Result of registry query:" + rawResult);
        if (!rawResult.contains("\t") && !rawResult.contains("    ")) {
            throw new NoSuchRegistryEntryException("Could not find registry entry with location " + location + " and key " + key);
        }
        String[] parsed = rawResult.contains("\t") ? rawResult.split("\t") : rawResult.split("    ");
        String result = parsed[parsed.length - 1];
        result = result.substring(0, result.length() - 4);
        return result;
    }

    public static void writeRegistry(String location, String key, String value) throws IOException, WindowsRegistryAccessException {
        String command = "reg add \"" + location + '\"' + " /v " + key + " /d " + '\"' + value + '\"' + " /f";
        Process process = Runtime.getRuntime().exec(command);
        String rawResult = IOUtils.inputStreamAsString(process.getInputStream());
        if (!rawResult.contains("The operation completed successfully.")) {
            throw new WindowsRegistryAccessException("Could not write to " + location + " and key " + key + " with value: " + value + "\nError message: " + IOUtils.inputStreamAsString(process.getErrorStream()));
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException, NoSuchRegistryEntryException {
        String value = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\FileMaker\\FileMaker Server\\9.0\\Services", "InstallLocation");
        System.out.println(value);
    }
}

