/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing.editors;

import com.prosc.swing.editors.PropertyEditorComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorSupport;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorEditor
extends PropertyEditorSupport {
    private JPanel colorPanel = new JPanel(new FlowLayout(0, 5, 1));
    protected JButton colorButton;
    transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private JButton clearButton;

    public ColorEditor() {
        this(false);
    }

    public ColorEditor(boolean nullable) {
        this.colorButton = new JButton(""){

            @Override
            public void paintComponent(Graphics g) {
                if (ColorEditor.this.getValue() != null) {
                    g.setColor(ColorEditor.this.getValue());
                } else {
                    g.setColor(new Color(238, 238, 238));
                }
                g.fillRect(0, 0, this.getSize().width, this.getSize().height);
                super.paintComponent(g);
            }
        };
        this.colorButton.setOpaque(true);
        this.colorButton.setBackground(this.getValue());
        this.colorButton.setContentAreaFilled(false);
        this.colorButton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.colorButton.setPreferredSize(new Dimension(16, 16));
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JLabel previewLabel = new JLabel("----------------", 0);
                previewLabel.setFont(new Font("Serif", 3, 48));
                previewLabel.setSize(previewLabel.getPreferredSize());
                previewLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
                previewLabel.setOpaque(true);
                if (ColorEditor.this.getValue() != null) {
                    previewLabel.setBackground(ColorEditor.this.getValue());
                } else {
                    previewLabel.setBackground(Color.BLACK);
                }
                final JColorChooser colorChooser = ColorEditor.this.getValue() != null ? new JColorChooser(ColorEditor.this.getValue()) : new JColorChooser(Color.BLACK);
                colorChooser.setPreviewPanel(previewLabel);
                ColorSelectionModel model = colorChooser.getSelectionModel();
                model.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent evt) {
                        ColorSelectionModel model = (ColorSelectionModel)evt.getSource();
                        previewLabel.setBackground(model.getSelectedColor());
                    }
                });
                ActionListener okActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (colorChooser.getColor() != null) {
                            ColorEditor.this.setValue(colorChooser.getColor());
                        }
                    }
                };
                JDialog dialog = JColorChooser.createDialog(null, "Change Color", true, colorChooser, okActionListener, null);
                dialog.setVisible(true);
            }
        });
        this.colorPanel.add(this.colorButton);
        this.clearButton = new JButton(new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorEditor.this.setValue(null);
            }
        });
        this.clearButton.setVisible(nullable);
        this.colorPanel.add(this.clearButton);
    }

    public void setNullable(boolean nullable) {
        this.clearButton.setVisible(nullable);
    }

    public boolean isNullable() {
        return this.clearButton.isVisible();
    }

    public void setValue(Color value) {
        super.setValue(value);
        this.colorButton.setBackground(value);
        this.colorButton.setToolTipText(this.colorDescription(value));
        this.firePropertyChange();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Color getValue() {
        return (Color)super.getValue();
    }

    @Override
    public Component getCustomEditor() {
        return this.colorPanel;
    }

    private String colorDescription(Color c) {
        if (c == null) {
            return "null";
        }
        return "rgb(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ")";
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void firePropertyChange() {
        super.firePropertyChange();
        this.pcs.firePropertyChange("value", null, this.getValue());
    }

    public static final class Wrapper
    extends PropertyEditorComponent {
        public Wrapper() {
            super(new ColorEditor());
        }
    }
}

