/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.core.WrapperException;
import com.prosc.shared.ExceptionUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwingUtils {
    private static final InputVerifier DEFAULT_INPUT_VERIFIER = new DefaultInputVerifier();

    public static JFrame showComponent(Component component) {
        return SwingUtils.showComponent(component, 0);
    }

    public static JFrame showComponent(Component component, int insetAmount) {
        JFrame frame = new JFrame(component.getClass().getName());
        if (insetAmount > 0) {
            EmptyBorder insetBorder = new EmptyBorder(insetAmount, insetAmount, insetAmount, insetAmount);
            JPanel borderPanel = new JPanel();
            borderPanel.setLayout(new BorderLayout());
            borderPanel.setBorder(insetBorder);
            borderPanel.add(component);
            frame.getContentPane().add(borderPanel);
        } else {
            frame.getContentPane().add(component);
        }
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        return frame;
    }

    public static BufferedImage renderComponentToImage(Component component, Rectangle clipArea) {
        BufferedImage image = new BufferedImage(clipArea.width, clipArea.height, 2);
        Graphics2D g = image.createGraphics();
        g.setClip(0, 0, clipArea.width, clipArea.height);
        g.translate(-clipArea.x, -clipArea.y);
        Color oldBackground = component.getBackground();
        component.setBackground(new Color(0, 0, 0, 0));
        component.paint(g);
        component.setBackground(oldBackground);
        g.dispose();
        return image;
    }

    public static void addInputValidator(JTextField field) {
        field.setInputVerifier(DEFAULT_INPUT_VERIFIER);
    }

    public static void enableDragging(JComponent c) {
        DragGestureListener dragGestureListener = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent event) {
                JComponent c = (JComponent)event.getComponent();
                TransferHandler transferHandler = c.getTransferHandler();
                transferHandler.exportAsDrag(c, event.getTriggerEvent(), transferHandler.getSourceActions(c));
            }
        };
        Toolkit.getDefaultToolkit().createDragGestureRecognizer(MouseDragGestureRecognizer.class, DragSource.getDefaultDragSource(), c, c.getTransferHandler().getSourceActions(c), dragGestureListener);
    }

    @Nullable
    public static File showFileDialog(JFrame parent, int mode, String title, File file) {
        FileDialog fd = new FileDialog((Frame)parent, title, mode);
        fd.setFile(file.getName());
        fd.setDirectory(file.getParent());
        fd.setVisible(true);
        if (fd.getDirectory() != null && fd.getFile() != null) {
            return new File(fd.getDirectory(), fd.getFile());
        }
        return null;
    }

    public static void setEnabledRecursive(Component component, boolean enabled) {
        component.setEnabled(enabled);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int n = 0; n < container.getComponentCount(); ++n) {
                SwingUtils.setEnabledRecursive(container.getComponent(n), enabled);
            }
        }
    }

    public static <E> E invokeAndWaitImproved(final Callable<E> callable) throws Exception, InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            return callable.call();
        }
        final AtomicReference ref = new AtomicReference();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        ref.set(callable.call());
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                }
            });
            return (E)ref.get();
        }
        catch (InvocationTargetException e) {
            throw ExceptionUtils.unwrapException(e);
        }
    }

    public static boolean isMac() {
        return System.getProperty("mrj.version") != null;
    }

    public static void installCloseKeys(final RootPaneContainer c) {
        ActionListener closer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)((Object)c)).setVisible(false);
            }
        };
        JRootPane rootPane = c.getRootPane();
        rootPane.registerKeyboardAction(closer, KeyStroke.getKeyStroke(27, 0), 2);
        if (SwingUtils.isMac()) {
            Toolkit toolkit = ((Component)((Object)c)).getToolkit();
            rootPane.registerKeyboardAction(closer, KeyStroke.getKeyStroke(87, toolkit.getMenuShortcutKeyMask()), 2);
        }
    }

    public static JComponent createFixedWidthHtmlMessage(String message) {
        return ExceptionUtils.createFixedWidthHtmlMessage(message, 700);
    }

    public static void setTabForFocus(Component c) {
        HashSet<KeyStroke> strokes = new HashSet<KeyStroke>(Arrays.asList(KeyStroke.getKeyStroke("pressed TAB")));
        c.setFocusTraversalKeys(0, strokes);
        strokes = new HashSet<KeyStroke>(Arrays.asList(KeyStroke.getKeyStroke("shift pressed TAB")));
        c.setFocusTraversalKeys(1, strokes);
    }

    @Nullable
    public static <E> E findChildRecursive(@NotNull JComponent parent, @NotNull Class<E> ofType) {
        if (parent == null) {
            SwingUtils.$$$reportNull$$$0(0);
        }
        if (ofType == null) {
            SwingUtils.$$$reportNull$$$0(1);
        }
        E result = null;
        for (Component eachChild : parent.getComponents()) {
            if (ofType.isAssignableFrom(eachChild.getClass())) {
                return (E)eachChild;
            }
            E e = SwingUtils.findChildRecursive((JComponent)eachChild, ofType);
            result = e;
            if (e == null) continue;
            return result;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "ofType";
                break;
            }
        }
        objectArray[1] = "com/prosc/swing/SwingUtils";
        objectArray[2] = "findChildRecursive";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DefaultInputVerifier
    extends InputVerifier {
        private DefaultInputVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            JFormattedTextField ftf;
            JFormattedTextField.AbstractFormatter formatter;
            if (input instanceof JFormattedTextField && (formatter = (ftf = (JFormattedTextField)input).getFormatter()) != null) {
                String text = ftf.getText();
                try {
                    formatter.stringToValue(text);
                }
                catch (ParseException pe) {
                    return false;
                }
            }
            return true;
        }
    }
}

