/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.shared.StringUtils;
import com.prosc.swing.TwoColumnTableLayout;
import com.prosc.swing.editors.PropertyEditorUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class PropertyInspector
extends JPanel {
    private static final Logger log = Logger.getLogger(PropertyInspector.class.getName());
    private Object bean;
    private PropertyChangeListener beanListener;
    private Method removeListenerMethod = null;
    private List<PropertyDescriptor> properties;
    private boolean showExpertProperties = true;
    private boolean showReadOnlyProperties = false;
    private boolean ignoreEvents = false;
    private Set<PropertyChangeListener> beanListeners1 = new HashSet<PropertyChangeListener>(1);
    private Map<String, Set<PropertyChangeListener>> beanListeners2 = new HashMap<String, Set<PropertyChangeListener>>(1);
    private boolean beautifyLabels;
    private Map<String, Component> editorComponentsByPropertyName = new HashMap<String, Component>();

    public PropertyInspector(Object bean) {
        this();
        this.setBean(bean);
    }

    public PropertyInspector() {
        super(new TwoColumnTableLayout(new Insets(2, 10, 2, 3)));
        if (Beans.isDesignTime()) {
            this.add(new JLabel("Property1"));
            this.add(new JTextArea(1, 20));
            this.add(new JLabel("Property2"));
            this.add(new JTextArea(1, 20));
            this.add(new JLabel("Property3"));
            this.add(new JTextArea(1, 20));
        }
        this.setPreferredSize(new Dimension(300, 300));
    }

    public void initialize() {
        this.extractProperties();
        this.constructPanel();
    }

    public boolean isShowExpertProperties() {
        return this.showExpertProperties;
    }

    public void setShowExpertProperties(boolean showExpertProperties) {
        this.showExpertProperties = showExpertProperties;
    }

    public boolean isShowReadOnlyProperties() {
        return this.showReadOnlyProperties;
    }

    public void setShowReadOnlyProperties(boolean showReadOnlyProperties) {
        this.showReadOnlyProperties = showReadOnlyProperties;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(@Nullable Object component) {
        this.removeAll();
        this.editorComponentsByPropertyName.clear();
        if (this.bean != null && this.removeListenerMethod != null && this.beanListener != null) {
            try {
                this.removeListenerMethod.invoke(this.bean, this.beanListener);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not remove property change listener from " + this.bean, e);
            }
        }
        this.bean = component;
        this.initialize();
        this.revalidate();
        this.repaint();
    }

    public List<PropertyDescriptor> getProperties() {
        return this.properties;
    }

    @Nullable
    public Component editorComponentFor(String propertyName) {
        return this.editorComponentsByPropertyName.get(propertyName);
    }

    public void setProperties(List<PropertyDescriptor> properties) {
        this.properties = properties;
    }

    private void extractProperties() {
        if (this.bean != null) {
            List<PropertyDescriptor> propertyDescriptors = this.getPropertyDescriptorsForCurrentBean();
            this.setProperties(propertyDescriptors);
        } else {
            this.setProperties(Collections.emptyList());
        }
    }

    protected List<PropertyDescriptor> getPropertyDescriptorsForCurrentBean() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            return new ArrayList<PropertyDescriptor>(Arrays.asList(beanInfo.getPropertyDescriptors()));
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Could not read properties for " + this.bean, e);
        }
    }

    public void constructPanel() {
        final Object bean = this.bean;
        for (final PropertyDescriptor property : this.properties) {
            JComboBox editorComponent;
            Object value;
            PropertyEditor propertyEditor;
            String name;
            block28: {
                name = property.getName();
                if ("class".equals(name) || !this.shouldIncludeProperty(property)) continue;
                Method readMethod = property.getReadMethod();
                if (!this.showExpertProperties && property.isExpert() || !this.showReadOnlyProperties && property.getWriteMethod() == null) continue;
                PropertyEditor tempPropertyEditor = this.createCustomPropertyEditor(property);
                if (tempPropertyEditor == null) {
                    if (property.getPropertyEditorClass() != null) {
                        try {
                            tempPropertyEditor = (PropertyEditor)property.getPropertyEditorClass().newInstance();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not instantiate property editor: " + property.getPropertyEditorClass(), e);
                        }
                    } else {
                        Class<?> propertyType = property.getPropertyType();
                        if (propertyType != null) {
                            tempPropertyEditor = PropertyEditorManager.findEditor(propertyType);
                        }
                    }
                }
                propertyEditor = tempPropertyEditor;
                if (readMethod == null) continue;
                try {
                    value = readMethod.invoke(bean, new Object[0]);
                    if (propertyEditor == null) break block28;
                    propertyEditor.setValue(value);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Could not read value for property " + name + " in object " + bean, e);
                    this.add(new JLabel(e.toString()));
                    continue;
                }
            }
            final Method writeMethod = property.getWriteMethod();
            this.beanListener = null;
            Method addListenerMethod = null;
            boolean setupListener = false;
            if (property.isBound()) {
                try {
                    addListenerMethod = bean.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                    this.removeListenerMethod = bean.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                    setupListener = true;
                }
                catch (NoSuchMethodException e) {
                    log.warning("The class " + bean.getClass() + " advertises that it has bound properties, but it has no add/remove property change listener methods");
                }
            } else {
                log.finer(property.getName() + " is not a bound property");
            }
            if (propertyEditor == null && !property.getPropertyType().isEnum()) {
                if (!this.showReadOnlyProperties) continue;
                final JLabel jlabel = new JLabel(String.valueOf(value));
                editorComponent = jlabel;
                if (setupListener) {
                    this.beanListener = new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            jlabel.setText(String.valueOf(evt.getNewValue()));
                        }
                    };
                }
            } else if (propertyEditor == null || propertyEditor.getCustomEditor() == null) {
                if (property.getPropertyType().isEnum()) {
                    final JComboBox enumMenu = new JComboBox(property.getPropertyType().getEnumConstants());
                    enumMenu.setSelectedItem(value);
                    enumMenu.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (e.getStateChange() == 1) {
                                PropertyInspector.this.writeNewValue(bean, property, e.getItem());
                            }
                        }
                    });
                    editorComponent = enumMenu;
                    if (setupListener) {
                        this.beanListener = new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                enumMenu.setSelectedItem(evt.getNewValue());
                            }
                        };
                    }
                } else {
                    final JTextField textField = new JTextField(propertyEditor.getAsText());
                    editorComponent = textField;
                    textField.setInputVerifier(new InputVerifier(){

                        @Override
                        public boolean verify(JComponent input) {
                            propertyEditor.setAsText(textField.getText());
                            PropertyInspector.this.writeNewValue(bean, property, propertyEditor.getValue());
                            return true;
                        }
                    });
                    if (setupListener) {
                        this.beanListener = new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                propertyEditor.setValue(evt.getNewValue());
                                textField.setText(propertyEditor.getAsText());
                            }
                        };
                    }
                }
            } else {
                editorComponent = propertyEditor.getCustomEditor();
                propertyEditor.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (writeMethod == null) {
                            log.info("Cannot set property: " + property.getName() + "; has no write method.");
                        } else {
                            PropertyInspector.this.writeNewValue(bean, property, propertyEditor.getValue());
                            if (bean instanceof Component) {
                                ((Component)bean).validate();
                            }
                        }
                    }
                });
                if (setupListener) {
                    this.beanListener = new PropertyChangeListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (!PropertyInspector.this.ignoreEvents && evt.getOldValue() != evt.getNewValue()) {
                                try {
                                    PropertyInspector.this.ignoreEvents = true;
                                    propertyEditor.setValue(evt.getNewValue());
                                    for (PropertyChangeListener eachListener : PropertyInspector.this.beanListeners1) {
                                        eachListener.propertyChange(evt);
                                    }
                                    Set changeListenerSet = (Set)PropertyInspector.this.beanListeners2.get(evt.getPropertyName());
                                    if (changeListenerSet != null) {
                                        for (PropertyChangeListener eachListener : changeListenerSet) {
                                            eachListener.propertyChange(evt);
                                        }
                                    }
                                }
                                finally {
                                    PropertyInspector.this.ignoreEvents = false;
                                }
                            }
                        }
                    };
                }
            }
            if (setupListener) {
                try {
                    addListenerMethod.invoke(bean, property.getName(), this.beanListener);
                    log.finer("Listener added for property " + property.getName());
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Could not add PropertyChangeListener to " + bean, e);
                }
            }
            if (writeMethod == null) {
                ((Component)editorComponent).setEnabled(false);
            }
            editorComponent.setName(name);
            this.editorComponentsByPropertyName.put(property.getName(), editorComponent);
            this.addSeparatorBefore(property, editorComponent);
            JComponent label = this.labelForName(property);
            Component editorPanel = this.decorateEditorComponent(property, editorComponent);
            if (label != null) {
                this.add(label);
                this.add(editorPanel);
                continue;
            }
            this.add(editorPanel, TwoColumnTableLayout.SPAN_BOTH_COLUMNS);
        }
        this.setPreferredSize(null);
    }

    protected Component decorateEditorComponent(PropertyDescriptor property, Component editorComponent) {
        return editorComponent;
    }

    protected void addSeparatorBefore(PropertyDescriptor property, Component editorComponent) {
    }

    protected JComponent labelForName(PropertyDescriptor name) {
        String s = this.beautifyLabels ? StringUtils.beautifyAttributeName(name.getName()) : name.getName();
        return new JLabel(s);
    }

    protected boolean shouldIncludeProperty(PropertyDescriptor property) {
        return true;
    }

    protected PropertyEditor createCustomPropertyEditor(PropertyDescriptor property) {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    public void addBeanPropertyChangeListener(PropertyChangeListener listener) {
        this.beanListeners1.add(listener);
    }

    public void removeBeanPropertyChangeListener(PropertyChangeListener listener) {
        this.beanListeners1.remove(listener);
    }

    public void addBeanPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Set<PropertyChangeListener> children = this.beanListeners2.get(propertyName);
        if (children == null) {
            children = new HashSet<PropertyChangeListener>(1);
            this.beanListeners2.put(propertyName, children);
        }
        children.add(listener);
    }

    public void removeBeanPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Set<PropertyChangeListener> children = this.beanListeners2.get(propertyName);
        if (children != null) {
            children.remove(listener);
        }
    }

    public boolean isIgnoreEvents() {
        return this.ignoreEvents;
    }

    public void setIgnoreEvents(boolean ignoreEvents) {
        this.ignoreEvents = ignoreEvents;
    }

    private void writeNewValue(Object beanBeingEdited, PropertyDescriptor property, Object newValue) {
        if (!this.ignoreEvents) {
            String propertyName = property.getName();
            try {
                Object oldValue = null;
                if (property.getReadMethod() != null) {
                    oldValue = property.getReadMethod().invoke(beanBeingEdited, new Object[0]);
                }
                if (oldValue != null && oldValue.equals(newValue)) {
                    return;
                }
                if (oldValue == newValue) {
                    return;
                }
                this.writeNewValueToBean(property, newValue, oldValue, beanBeingEdited);
                HashSet<PropertyChangeListener> beanListeners = new HashSet<PropertyChangeListener>(this.beanListeners1);
                Set<PropertyChangeListener> children = this.beanListeners2.get(propertyName);
                if (children != null) {
                    beanListeners.addAll(children);
                }
                if (beanListeners.size() > 0) {
                    PropertyChangeEvent event = new PropertyChangeEvent(beanBeingEdited, propertyName, oldValue, newValue);
                    for (PropertyChangeListener eachListener : beanListeners) {
                        eachListener.propertyChange(event);
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not set value for " + propertyName + " (" + Arrays.asList(property.getWriteMethod().getParameterTypes()) + "): " + String.valueOf(newValue) + " (" + newValue.getClass().getName() + ") on bean " + this.bean.getClass().getName(), e);
                Throwable exception = e;
                if (exception instanceof InvocationTargetException) {
                    exception = exception.getCause();
                }
                JOptionPane.showMessageDialog(this, exception.toString(), exception.getClass().toString(), 0);
            }
        }
    }

    protected void writeNewValueToBean(PropertyDescriptor property, Object newValue, Object oldValue, Object beanBeingEdited) throws IllegalAccessException, InvocationTargetException {
        property.getWriteMethod().invoke(beanBeingEdited, newValue);
    }

    public void setBeautifyLabels(boolean beautifyLabels) {
        this.beautifyLabels = beautifyLabels;
        Object o = this.getBean();
        this.setBean(null);
        this.setBean(o);
    }

    static {
        PropertyEditorUtils.registerAll();
    }
}

