/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.swing.editors.BigDecimalEditor;
import com.prosc.swing.editors.BigIntegerEditor;
import com.prosc.swing.editors.ByteArrayEditor;
import com.prosc.swing.editors.ColorEditor;
import com.prosc.swing.editors.FontEditor;
import com.prosc.swing.editors.IntegerEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jetbrains.annotations.Nullable;

public class ObjectGraphGUI
extends JPanel {
    private static final Logger log = Logger.getLogger(ObjectGraphGUI.class.getName());
    private static final GridBagConstraints LEFT_COLUMN = new GridBagConstraints();
    private static final GridBagConstraints RIGHT_COLUMN = new GridBagConstraints();
    private static final GridBagConstraints BOTH_COLUMNS = new GridBagConstraints();
    private Object theInstance;
    private Border defaultFieldBorder = new JTextField().getBorder();
    private boolean isReadOnly = false;
    private PropertyFilter filter;

    public ObjectGraphGUI() {
        this(false, null);
    }

    public ObjectGraphGUI(boolean readOnly) {
        this(readOnly, null);
    }

    public ObjectGraphGUI(boolean isReadOnly, @Nullable PropertyFilter filter) {
        this.isReadOnly = isReadOnly;
        this.filter = filter;
    }

    private ObjectGraphGUI(Class<?> objectClass, Object instance, Set<Object> graph, Object parent, PropertyDescriptor propertyDesc, boolean isReadOnly, PropertyFilter filter) throws IntrospectionException, IllegalAccessException {
        this(isReadOnly, filter);
        this.initForInstance(objectClass, null, instance, graph, parent, propertyDesc);
    }

    public void setObjectInstance(Object theInstance) throws IntrospectionException, IllegalAccessException {
        this.setObjectInstance(theInstance, null);
    }

    public void setObjectInstance(Object theInstance, String[] propertyOrder) throws IntrospectionException, IllegalAccessException {
        this.theInstance = theInstance;
        this.removeAll();
        if (theInstance != null) {
            HashSet<Object> graph = new HashSet<Object>();
            this.initForInstance(theInstance.getClass(), propertyOrder, theInstance, graph, null, null);
        }
        this.repaint();
        this.revalidate();
    }

    public Object getObjectInstance() {
        return this.theInstance;
    }

    private void initForInstance(final Class<?> objectClass, final String[] propertyOrder, final Object theInstance, final Set<Object> graph, final Object parent, final PropertyDescriptor propertyDesc) throws IntrospectionException, IllegalAccessException {
        this.setBorder(BorderFactory.createEtchedBorder());
        final GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        if (graph.contains(theInstance)) {
            JLabel infiniteLoop = new JLabel("Duplicate reference: " + theInstance);
            layout.setConstraints(infiniteLoop, BOTH_COLUMNS);
            this.add(infiniteLoop);
            return;
        }
        if (theInstance != null) {
            graph.add(theInstance);
        }
        if (parent != null && propertyDesc.getWriteMethod() != null && !this.isReadOnly) {
            if (theInstance == null) {
                final Class newInstanceClass = this.findConcreteClass(propertyDesc.getPropertyType());
                try {
                    final Constructor noArgConstructor = newInstanceClass.getConstructor(new Class[0]);
                    final JButton create = new JButton("Create");
                    create.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                XMLGregorianCalendar newInstance = newInstanceClass == XMLGregorianCalendar.class ? DatatypeFactory.newInstance().newXMLGregorianCalendar() : noArgConstructor.newInstance(new Object[0]);
                                ObjectGraphGUI.this.removeAll();
                                propertyDesc.getWriteMethod().invoke(parent, newInstance);
                                ObjectGraphGUI.this.initForInstance(objectClass, propertyOrder, newInstance, graph, parent, propertyDesc);
                                ObjectGraphGUI.this.revalidate();
                            }
                            catch (Exception e1) {
                                String msg = "Could not create new " + newInstanceClass.getName();
                                log.log(Level.SEVERE, msg, e1);
                                JOptionPane.showMessageDialog(create, msg + ": " + e1.toString());
                            }
                        }
                    });
                    layout.setConstraints(create, BOTH_COLUMNS);
                    this.add(create);
                }
                catch (NoSuchMethodException e) {
                    JLabel noConstructor = new JLabel("Can't create: Missing no-arg constructor for class " + objectClass);
                    layout.setConstraints(noConstructor, BOTH_COLUMNS);
                    this.add(noConstructor);
                    return;
                }
                this.revalidate();
            } else {
                JButton delete = new JButton("Nullify");
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ObjectGraphGUI.this.removeAll();
                        try {
                            propertyDesc.getWriteMethod().invoke(parent, new Object[]{null});
                            ObjectGraphGUI.this.initForInstance(objectClass, propertyOrder, null, graph, parent, propertyDesc);
                        }
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                        finally {
                            ObjectGraphGUI.this.revalidate();
                        }
                    }
                });
                layout.setConstraints(delete, BOTH_COLUMNS);
                this.add(delete);
            }
        }
        if (theInstance == null) {
            return;
        }
        if (theInstance instanceof Collection) {
            final Collection objects = (Collection)theInstance;
            for (Object eachItem : objects) {
                this.addCollectionItem(objectClass, graph, propertyDesc, layout, objects, eachItem, this.getComponentCount());
            }
            if (!this.isReadOnly) {
                Class newInstanceClass = objectClass;
                newInstanceClass = this.findConcreteClass(newInstanceClass);
                try {
                    final Constructor noArgConstructor = newInstanceClass.getConstructor(new Class[0]);
                    JButton insert = new JButton("insert");
                    insert.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                Object newInstance = noArgConstructor.newInstance(new Object[0]);
                                objects.add(newInstance);
                                ObjectGraphGUI.this.addCollectionItem(objectClass, graph, propertyDesc, layout, objects, newInstance, ObjectGraphGUI.this.getComponentCount() - 1);
                                ObjectGraphGUI.this.revalidate();
                            }
                            catch (Exception e1) {
                                throw new RuntimeException(e1);
                            }
                        }
                    });
                    layout.setConstraints(insert, BOTH_COLUMNS);
                    this.add(insert);
                }
                catch (NoSuchMethodException e) {
                    JLabel noConstructor = new JLabel("Can't create: Missing no-arg constructor for class " + objectClass);
                    layout.setConstraints(noConstructor, BOTH_COLUMNS);
                    this.add(noConstructor);
                    return;
                }
            }
        } else {
            BeanInfo beanInfo = Introspector.getBeanInfo(objectClass);
            PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
            if (propertyOrder != null) {
                properties = this.resortProperties(properties, propertyOrder);
            }
            for (final PropertyDescriptor desc : properties) {
                Object subElementInstance;
                Class<?> propertyType;
                if (desc.getReadMethod() == null || (propertyType = desc.getPropertyType()) == Class.class || this.filter != null && this.filter.omit(desc)) continue;
                try {
                    Field field = desc.getReadMethod().getDeclaringClass().getDeclaredField(desc.getName());
                    if (Modifier.isTransient(field.getModifiers())) {
                        continue;
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Unable to determine field modifiers for " + desc + " in " + objectClass.getName(), e);
                }
                try {
                    subElementInstance = desc.getReadMethod().invoke(theInstance, new Object[0]);
                    if (parent != null && parent.equals(subElementInstance)) {
                        return;
                    }
                }
                catch (InvocationTargetException e) {
                    log.log(Level.WARNING, "Could not read the value for property " + desc.getName(), e);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                JComponent c = null;
                if (Collection.class.isAssignableFrom(propertyType)) {
                    Type genericReturnType = desc.getReadMethod().getGenericReturnType();
                    if (genericReturnType instanceof ParameterizedType) {
                        Type[] types = ((ParameterizedType)genericReturnType).getActualTypeArguments();
                        if (types.length == 1) {
                            Class genericType = types[0] instanceof Class ? (Class)types[0] : (Class)((TypeVariable)types[0]).getBounds()[0];
                            c = new ObjectGraphGUI(genericType, subElementInstance, graph, theInstance, desc, this.isReadOnly, this.filter);
                        } else {
                            log.info("Can't represent the collection for type " + propertyType + " with " + types.length + " generic types");
                        }
                    } else {
                        log.info("Can't represent the collection for type " + propertyType + " with " + genericReturnType + " generic types");
                    }
                } else {
                    final PropertyEditor editor = PropertyEditorManager.findEditor(propertyType);
                    if (editor != null) {
                        if (editor.supportsCustomEditor()) {
                            c = editor.getCustomEditor();
                            if (subElementInstance != null) {
                                editor.setValue(subElementInstance);
                            }
                        } else {
                            final JTextArea textArea = new JTextArea(){

                                @Override
                                public Dimension getMinimumSize() {
                                    Dimension result = super.getMinimumSize();
                                    result.width = 100;
                                    return result;
                                }
                            };
                            textArea.setBorder(this.defaultFieldBorder);
                            textArea.setLineWrap(true);
                            textArea.setWrapStyleWord(true);
                            c = textArea;
                            if (subElementInstance != null) {
                                editor.setValue(subElementInstance);
                                textArea.setText(editor.getAsText());
                            }
                            if (this.isReadOnly) {
                                textArea.setEditable(false);
                            } else {
                                c.addFocusListener(new FocusAdapter(){

                                    @Override
                                    public void focusLost(FocusEvent e) {
                                        try {
                                            editor.setAsText(textArea.getText());
                                        }
                                        catch (IllegalArgumentException e1) {
                                            log.warning(e1.toString());
                                            JOptionPane.showMessageDialog(ObjectGraphGUI.this, e1.toString());
                                        }
                                    }
                                });
                            }
                        }
                        if (desc.getWriteMethod() == null) {
                            if (c instanceof JTextComponent) {
                                ((JTextComponent)c).setEditable(false);
                            } else {
                                ((Component)c).setEnabled(false);
                            }
                        } else {
                            editor.addPropertyChangeListener(new PropertyChangeListener(){

                                @Override
                                public void propertyChange(PropertyChangeEvent evt) {
                                    try {
                                        desc.getWriteMethod().invoke(theInstance, editor.getValue());
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            });
                        }
                    } else if (propertyType.isEnum()) {
                        if (this.isReadOnly) {
                            if (subElementInstance != null) {
                                c = new JLabel(subElementInstance.toString());
                            }
                        } else {
                            JComboBox enums;
                            ?[] constants = propertyType.getEnumConstants();
                            Vector enumItems = new Vector(constants.length + 1);
                            enumItems.add(null);
                            enumItems.addAll(Arrays.asList(constants));
                            c = enums = new JComboBox(enumItems);
                            if (subElementInstance != null) {
                                enums.setSelectedItem(subElementInstance);
                            }
                            enums.addItemListener(new ItemListener(){

                                @Override
                                public void itemStateChanged(ItemEvent e) {
                                    try {
                                        desc.getWriteMethod().invoke(theInstance, e.getItem());
                                    }
                                    catch (Exception e1) {
                                        throw new RuntimeException(e1);
                                    }
                                }
                            });
                        }
                    } else if (propertyType.isArray()) {
                        Vector<Object> listData = new Vector<Object>();
                        int length = subElementInstance == null ? 0 : Array.getLength(subElementInstance);
                        for (int i = 0; i < length; ++i) {
                            Object eachArrayValue = Array.get(subElementInstance, i);
                            listData.add(eachArrayValue);
                        }
                        c = new JScrollPane(new JList(listData));
                    } else if (propertyType.getName().startsWith("java")) {
                        c = new JTextField(String.valueOf(subElementInstance));
                        ((JTextField)c).setEditable(false);
                    } else {
                        c = new ObjectGraphGUI(propertyType, subElementInstance, graph, theInstance, desc, this.isReadOnly, this.filter);
                    }
                }
                if (c == null) continue;
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                ((Component)c).setFocusTraversalKeys(0, focusManager.getDefaultFocusTraversalKeys(0));
                ((Component)c).setFocusTraversalKeys(1, focusManager.getDefaultFocusTraversalKeys(1));
                JLabel propertyLabel = new JLabel(desc.getDisplayName());
                layout.setConstraints(propertyLabel, LEFT_COLUMN);
                this.add(propertyLabel);
                layout.setConstraints(c, RIGHT_COLUMN);
                this.add(c);
            }
        }
        this.revalidate();
    }

    private PropertyDescriptor[] resortProperties(PropertyDescriptor[] input, String[] order) {
        PropertyDescriptor[] result = new PropertyDescriptor[input.length];
        LinkedHashMap<String, PropertyDescriptor> oldOrder = new LinkedHashMap<String, PropertyDescriptor>(input.length);
        for (PropertyDescriptor pd : input) {
            oldOrder.put(pd.getName().toLowerCase(), pd);
        }
        int n = 0;
        for (String name : order) {
            if (name.length() == 0) continue;
            PropertyDescriptor pd = (PropertyDescriptor)oldOrder.remove(name.toLowerCase());
            if (pd == null) {
                log.warning("Property '" + name + "' was specified in the sort order, but does exist in the list of actual property descriptors.");
                continue;
            }
            result[n++] = pd;
        }
        for (PropertyDescriptor pd : oldOrder.values()) {
            result[n++] = pd;
        }
        return result;
    }

    private void addCollectionItem(Class<?> objectClass, Set<Object> graph, PropertyDescriptor propertyDesc, GridBagLayout layout, final Collection<Object> objects, final Object eachItem, int insertIndex) throws IntrospectionException, IllegalAccessException {
        final JButton removeButton = new JButton("remove");
        layout.setConstraints(removeButton, LEFT_COLUMN);
        if (!this.isReadOnly) {
            this.add((Component)removeButton, insertIndex++);
        }
        final ObjectGraphGUI collectionItem = new ObjectGraphGUI(eachItem.getClass(), eachItem, graph, null, propertyDesc, this.isReadOnly, this.filter);
        layout.setConstraints(collectionItem, RIGHT_COLUMN);
        this.add((Component)collectionItem, insertIndex);
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                objects.remove(eachItem);
                ObjectGraphGUI.this.remove(removeButton);
                ObjectGraphGUI.this.remove(collectionItem);
                ObjectGraphGUI.this.revalidate();
            }
        });
    }

    private Class findConcreteClass(Class aClass) {
        if (aClass == List.class) {
            return LinkedList.class;
        }
        if (aClass == Set.class) {
            return HashSet.class;
        }
        if (aClass == Collection.class) {
            return LinkedList.class;
        }
        if (aClass == Queue.class) {
            return Queue.class;
        }
        return aClass;
    }

    private static void initializePropertyEditors() {
        PropertyEditorManager.registerEditor(Integer.class, IntegerEditor.class);
        PropertyEditorManager.registerEditor(BigDecimal.class, BigDecimalEditor.class);
        PropertyEditorManager.registerEditor(BigInteger.class, BigIntegerEditor.class);
        PropertyEditorManager.registerEditor(byte[].class, ByteArrayEditor.class);
        PropertyEditorManager.registerEditor(Font.class, FontEditor.class);
        PropertyEditorManager.registerEditor(Color.class, ColorEditor.class);
    }

    static {
        ObjectGraphGUI.LEFT_COLUMN.anchor = 12;
        ObjectGraphGUI.LEFT_COLUMN.ipadx = 3;
        ObjectGraphGUI.RIGHT_COLUMN.weightx = 1.0;
        ObjectGraphGUI.RIGHT_COLUMN.fill = 2;
        ObjectGraphGUI.RIGHT_COLUMN.anchor = 18;
        ObjectGraphGUI.RIGHT_COLUMN.gridwidth = 0;
        ObjectGraphGUI.BOTH_COLUMNS.anchor = 18;
        ObjectGraphGUI.BOTH_COLUMNS.gridwidth = 0;
        ObjectGraphGUI.BOTH_COLUMNS.weightx = 1.0;
        ObjectGraphGUI.BOTH_COLUMNS.ipadx = 3;
        ObjectGraphGUI.initializePropertyEditors();
    }

    public static interface PropertyFilter {
        public boolean omit(PropertyDescriptor var1);
    }
}

