/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.beans.BeanUtils;
import com.prosc.shared.StringUtils;
import com.prosc.swing.ListModelWrapper;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.Nullable;

public class JavaBeanTableModel<T>
extends AbstractTableModel {
    private String[] propertyNames;
    private Class[] propertyTypes;
    private String[] columnHeaders;
    private Method[] getters;
    private Method[] setters;
    private ListModel<T> data;
    private int columnCount;
    private ListDataListener dataListener;
    boolean readOnly;

    public JavaBeanTableModel(Class beanClass, ListModel data, String[] propertyNames) throws IntrospectionException {
        if (beanClass == null || propertyNames == null || data == null) {
            throw new IllegalArgumentException("You cannot pass a null as a parameter.");
        }
        this.propertyNames = propertyNames;
        this.init(beanClass, data);
    }

    public JavaBeanTableModel(Class<T> beanClass, @Nullable ListModel data) {
        try {
            if (beanClass == null) {
                throw new IllegalArgumentException("You cannot pass a null as a parameter.");
            }
            if (data == null) {
                data = new ListModelWrapper(new ArrayList(0));
            }
            PropertyDescriptor[] properties = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
            String[] names = new String[properties.length - 1];
            int m = 0;
            for (int n = 0; n < properties.length; ++n) {
                if ("class".equals(properties[n].getName())) continue;
                names[m] = properties[n].getDisplayName();
                ++m;
            }
            this.propertyNames = names;
            this.init(beanClass, data);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    private void init(Class<T> beanClass, ListModel<T> data) throws IntrospectionException {
        this.columnHeaders = new String[this.propertyNames.length];
        for (int i = 0; i < this.propertyNames.length; ++i) {
            String propertyName = this.propertyNames[i];
            this.columnHeaders[i] = StringUtils.beautifyAttributeName(propertyName);
        }
        this.columnCount = this.propertyNames.length;
        this.getters = new Method[this.columnCount];
        this.setters = new Method[this.columnCount];
        this.propertyTypes = new Class[this.columnCount];
        for (int n = 0; n < this.columnCount; ++n) {
            String eachPropertyName = this.propertyNames[n];
            PropertyDescriptor descriptor = BeanUtils.getPropertyNamed(beanClass, eachPropertyName);
            this.propertyTypes[n] = descriptor.getPropertyType();
            this.getters[n] = descriptor.getReadMethod();
            this.setters[n] = descriptor.getWriteMethod();
        }
        this.data = data;
        this.dataListener = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                JavaBeanTableModel.this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                JavaBeanTableModel.this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                JavaBeanTableModel.this.fireTableDataChanged();
            }
        };
        data.addListDataListener(new WeakListDataListener(this.dataListener, data));
    }

    @Override
    public int getRowCount() {
        return this.data.getSize();
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public T getValueForRow(int rowIndex) {
        return this.data.getElementAt(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        T whichObject = this.data.getElementAt(rowIndex);
        Method getter = this.getters[columnIndex];
        try {
            return getter == null ? null : getter.invoke(whichObject, new Object[0]);
        }
        catch (Exception e) {
            this.getters[columnIndex] = null;
            throw new RuntimeException("Unable to invoke " + getter + " on " + whichObject, e);
        }
    }

    @Override
    public String getColumnName(int column) {
        if (this.columnHeaders != null) {
            return this.columnHeaders[column];
        }
        return this.propertyNames[column];
    }

    public Class getColumnClass(int columnIndex) {
        Class type = this.propertyTypes[columnIndex];
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                type = Boolean.class;
            } else if (type == Byte.TYPE) {
                type = Byte.class;
            } else if (type == Character.TYPE) {
                type = Character.class;
            } else if (type == Short.TYPE) {
                type = Short.class;
            } else if (type == Integer.TYPE) {
                type = Integer.class;
            } else if (type == Float.TYPE) {
                type = Float.class;
            } else if (type == Double.TYPE) {
                type = Double.class;
            } else if (type == Long.TYPE) {
                type = Long.class;
            }
        }
        return type;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.readOnly) {
            return false;
        }
        return this.setters[columnIndex] != null;
    }

    public void setColumnHeaders(String[] columnHeaders) {
        if (columnHeaders.length != this.columnCount) {
            throw new IllegalStateException("columnHeaders array has " + columnHeaders.length + " elements; expected " + this.columnCount);
        }
        this.columnHeaders = columnHeaders;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.readOnly) {
            return;
        }
        T whichObject = this.data.getElementAt(rowIndex);
        Method setter = this.setters[columnIndex];
        try {
            setter.invoke(whichObject, aValue);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke " + setter + " on " + whichObject + " with value " + aValue, e);
        }
    }

    public ListModel getData() {
        return this.data;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        super.removeTableModelListener(l);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    private static final class WeakListDataListener
    implements ListDataListener {
        final WeakReference<ListDataListener> ref;
        final ListModel data;

        public WeakListDataListener(ListDataListener listDataListener, ListModel data) {
            this.ref = new WeakReference<ListDataListener>(listDataListener);
            this.data = data;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            ListDataListener l = this.getListenerOrNull();
            if (l != null) {
                l.intervalAdded(e);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            ListDataListener l = this.getListenerOrNull();
            if (l != null) {
                l.intervalRemoved(e);
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ListDataListener l = this.getListenerOrNull();
            if (l != null) {
                l.contentsChanged(e);
            }
        }

        public ListDataListener getListenerOrNull() {
            ListDataListener listener = (ListDataListener)this.ref.get();
            if (listener == null) {
                this.removeListener();
            }
            return listener;
        }

        private void removeListener() {
            this.data.removeListDataListener(this);
        }
    }
}

