/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.swing.InputStreamRangeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class InputStreamRangeModelTest {
    static InputStreamRangeModel model;
    private static JButton button;
    static Runnable readUrl;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        final JProgressBar progressBar = new JProgressBar();
        button = new JButton("Download something big");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                button.setEnabled(false);
                long bigsize = 4509715658L;
                model = new InputStreamRangeModel(new FakeInputStream(5000, bigsize), bigsize);
                progressBar.setModel(model);
                new Thread(readUrl).start();
            }
        });
        frame.getContentPane().add((Component)button, "North");
        frame.getContentPane().add((Component)progressBar, "South");
        frame.pack();
        frame.setVisible(true);
    }

    static {
        readUrl = new Runnable(){

            @Override
            public void run() {
                byte[] buffer = new byte[65536];
                try {
                    try {
                        while (model.read(buffer) != -1) {
                        }
                    }
                    finally {
                        model.close();
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "Finished downloading");
                            button.setEnabled(true);
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static class FakeInputStream
    extends InputStream {
        int duration;
        long bytesRemaining;
        long chunksize;
        long nextPause;

        public FakeInputStream(int milliseconds, long size) {
            this.duration = milliseconds;
            this.bytesRemaining = size;
            this.chunksize = this.bytesRemaining / (long)this.duration;
            this.nextPause = this.bytesRemaining - this.chunksize;
        }

        @Override
        public int read() throws IOException {
            if (this.bytesRemaining <= 0L) {
                return -1;
            }
            if (this.bytesRemaining < this.nextPause) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                this.nextPause = this.bytesRemaining - this.chunksize;
            }
            --this.bytesRemaining;
            return 42;
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return super.read(bytes);
        }

        @Override
        public int read(byte[] bytes, int i, int i1) throws IOException {
            return super.read(bytes, i, i1);
        }

        @Override
        public int available() throws IOException {
            long longResult = Math.min(this.bytesRemaining, Integer.MAX_VALUE);
            int result = (int)longResult;
            return result;
        }
    }
}

