/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class FlavorMap
implements Transferable {
    final Map<DataFlavor, Object> dataFlavors = new HashMap<DataFlavor, Object>();
    public static final DataFlavor HTML_STRING;
    public static final DataFlavor HTML_READER;
    public static final DataFlavor HTML_STREAM;
    public static final DataFlavor INTEGER;

    public static DataFlavor dataFlavorFor(Class aClass) {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref;class=" + aClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.dataFlavors.keySet().toArray(new DataFlavor[this.dataFlavors.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.dataFlavors.containsKey(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.dataFlavors.get(flavor);
    }

    public void setPlainText(String s) {
        this.dataFlavors.put(DataFlavor.stringFlavor, s);
        this.dataFlavors.put(DataFlavor.getTextPlainUnicodeFlavor(), new ByteArrayInputStream(s.getBytes()));
    }

    public void setHtmlText(String s) {
        this.dataFlavors.put(HTML_STRING, s);
        this.dataFlavors.put(HTML_READER, new StringReader(s));
        try {
            this.dataFlavors.put(HTML_STREAM, new ByteArrayInputStream(s.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void put(DataFlavor dataFlavor, Object selection) {
        this.dataFlavors.put(dataFlavor, selection);
    }

    static {
        try {
            HTML_STRING = new DataFlavor("text/html;class=java.lang.String");
            HTML_READER = new DataFlavor("text/html;class=java.io.Reader");
            HTML_STREAM = new DataFlavor("text/html;charset=utf-8;class=java.io.InputStream");
            INTEGER = FlavorMap.dataFlavorFor(Integer.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

