/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.shared.ReflectionFieldException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ReflectionUtils {
    public static <T> T getFieldValue(@NotNull Object source, String ... fieldNames) throws ReflectionFieldException {
        if (source == null) {
            ReflectionUtils.$$$reportNull$$$0(0);
        }
        if (fieldNames == null) {
            ReflectionUtils.$$$reportNull$$$0(1);
        }
        StringBuilder errorMessage = new StringBuilder();
        Object currentSource = source;
        String delimiter = "";
        for (String fieldName : fieldNames) {
            Class<?> whichClass;
            Object instance;
            if (currentSource instanceof Class) {
                instance = null;
                whichClass = (Class<?>)currentSource;
            } else {
                instance = currentSource;
                whichClass = currentSource.getClass();
            }
            errorMessage.append(delimiter).append(whichClass.getName()).append(":").append(fieldName);
            delimiter = " -> ";
            NoSuchFieldException noSuchField = null;
            Class<?> whichSubclass = whichClass;
            while (whichClass != null) {
                try {
                    Field field = whichClass.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    currentSource = field.get(instance);
                    noSuchField = null;
                    break;
                }
                catch (NoSuchFieldException e) {
                    if (noSuchField == null) {
                        noSuchField = e;
                    }
                    whichClass = whichClass.getSuperclass();
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (noSuchField == null) continue;
            throw new ReflectionFieldException(errorMessage.toString(), whichSubclass, fieldName, instance, noSuchField);
        }
        return (T)currentSource;
    }

    public static <T> T getMethodResult(@NotNull Object source, @NotNull String methodName, Object ... parameters) {
        if (source == null) {
            ReflectionUtils.$$$reportNull$$$0(2);
        }
        if (methodName == null) {
            ReflectionUtils.$$$reportNull$$$0(3);
        }
        String similarName = null;
        Class<?> currentClass = source.getClass();
        HashSet<String> allMethods = new HashSet<String>();
        block3: do {
            Method[] declaredMethods = currentClass.getDeclaredMethods();
            for (Method method : declaredMethods) {
                allMethods.add(method.getName());
                if (methodName.equals(method.getName())) {
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length != parameters.length) continue;
                    for (int n = 0; n < paramTypes.length; ++n) {
                        if (!paramTypes[n].isAssignableFrom(parameters[n].getClass())) continue block3;
                    }
                    try {
                        method.setAccessible(true);
                        return (T)method.invoke(source, parameters);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!methodName.equalsIgnoreCase(method.getName())) continue;
                similarName = method.getName();
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        ArrayList paramTypes = new ArrayList(parameters.length);
        for (Object parameter : parameters) {
            paramTypes.add(parameter.getClass());
        }
        String msg = "There is no method named '" + methodName + "' defined in class " + source.getClass() + " with these parameter types: " + paramTypes;
        if (similarName != null) {
            msg = msg + ". Perhaps you meant to call '" + similarName + "'?";
        }
        ArrayList allMethodsSorted = new ArrayList(allMethods);
        Collections.sort(allMethodsSorted);
        msg = msg + "\nComplete list of methods: " + allMethodsSorted.toString();
        throw new RuntimeException(msg);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        objectArray2[1] = "com/prosc/shared/ReflectionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

