/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

public class IdentityHashSet<E>
implements Set<E> {
    private IdentityHashMap<E, Object> map;
    private final Object placeholder = new Object();

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(int expectedMaxSize) {
        this.map = new IdentityHashMap(expectedMaxSize);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, this.placeholder) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = false;
        for (E eachItem : c) {
            result = this.add(eachItem) || result;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            result = true;
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object eachItem : c) {
            result = this.remove(eachItem) || result;
        }
        return result;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

