/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class HttpIOException
extends IOException {
    private static final long serialVersionUID = 5141008280309147154L;
    private final URL requestUrl;
    private final String errorString;
    private final int responseCode;
    @Nullable
    private final Map<String, List<String>> headers;

    public URL getRequestUrl() {
        return this.requestUrl;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    @Nullable
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public HttpIOException(URL requestUrl, String errorString, int responseCode, Map<String, List<String>> headers) {
        this((String)null, requestUrl, errorString, responseCode, headers);
    }

    public HttpIOException(String message, URL requestUrl, String errorString, int responseCode, @Nullable Map<String, List<String>> headers) {
        super(message);
        this.requestUrl = requestUrl;
        this.errorString = errorString;
        this.responseCode = responseCode;
        this.headers = new HashMap<String, List<String>>(headers);
    }

    public HttpIOException(Throwable cause, URL requestUrl, String errorString, int responseCode, @Nullable Map<String, List<String>> headers) {
        this("HTTP " + responseCode + ": " + cause.getMessage(), cause, requestUrl, errorString, responseCode, headers);
    }

    public HttpIOException(String message, Throwable cause, URL requestUrl, String errorString, int responseCode, @Nullable Map<String, List<String>> headers) {
        super(message, cause);
        this.requestUrl = requestUrl;
        this.errorString = errorString;
        this.responseCode = responseCode;
        this.headers = new HashMap<String, List<String>>(headers);
    }
}

