/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.io.FileType;
import com.prosc.io.FullScanNeededException;
import com.prosc.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileTypes {
    private static final int LONGEST_CHUNK_NEEDED = 516;
    private static final byte[] PNG_HEADER = new byte[]{-119, 80, 78, 71};
    private static final byte[] PDF_HEADER = new byte[]{37, 80, 68, 70};
    private static final byte[] JPEG_HEADER = new byte[]{-1, -40, -1};
    private static final byte[] GIF_HEADER = new byte[]{71, 73, 70, 56};
    private static final byte[] TIFF_BIGENDIAN = new byte[]{77, 77, 0, 42};
    private static final byte[] TIFF_LITTLEENDIAN = new byte[]{73, 73, 0, 42};
    private static final byte[] DOC_BIGENDIAN = new byte[]{-20, -91, -63, 0};
    private static final byte[] DOC_LITTLEENDIAN = new byte[]{-91, -20, 0, -63};
    private static final byte[] ZIP_ARCHIVE = new byte[]{80, 75, 3, 4};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileType guessTypeFromHeader(BufferedInputStream content) throws IOException, FullScanNeededException {
        content.mark(516);
        try {
            byte[] header = new byte[516];
            int bytesRead = content.read(header);
            FileType result = FileTypes.guessTypeFromHeader(header, bytesRead);
            if (result == FileType.zip) {
                throw new FullScanNeededException(FileType.zip);
            }
            FileType fileType = result;
            return fileType;
        }
        finally {
            content.reset();
        }
    }

    public static FileType guessTypeFromHeader(byte[] header, int bytesRead) {
        byte[] header_4;
        if (bytesRead >= 3 && Arrays.equals(Arrays.copyOf(header, 3), JPEG_HEADER)) {
            return FileType.jpeg;
        }
        if (bytesRead >= 4) {
            header_4 = Arrays.copyOf(header, 4);
            if (Arrays.equals(header_4, PNG_HEADER)) {
                return FileType.png;
            }
            if (Arrays.equals(header_4, PDF_HEADER)) {
                return FileType.pdf;
            }
            if (Arrays.equals(header_4, GIF_HEADER)) {
                return FileType.gif;
            }
            if (Arrays.equals(header_4, TIFF_BIGENDIAN) || Arrays.equals(header_4, TIFF_LITTLEENDIAN)) {
                return FileType.tiff;
            }
            if (Arrays.equals(header_4, ZIP_ARCHIVE)) {
                return FileType.zip;
            }
        }
        if (bytesRead >= 516) {
            header_4 = new byte[4];
            System.arraycopy(header, 512, header_4, 0, 4);
            if (Arrays.equals(header_4, DOC_BIGENDIAN) || Arrays.equals(header_4, DOC_LITTLEENDIAN)) {
                return FileType.doc;
            }
        }
        return FileType.unknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileType guessTypeFromContents(InputStream content) throws IOException {
        try {
            if (!content.markSupported()) {
                content = new BufferedInputStream(content);
            }
            content.mark(516);
            try {
                byte[] header = new byte[516];
                int bytesRead = content.read(header);
                FileType result = FileTypes.guessTypeFromHeader(header, bytesRead);
                if (result != FileType.zip) {
                    FileType fileType = result;
                    return fileType;
                }
            }
            finally {
                content.reset();
            }
            FileType fileType = FileTypes.guessTypeFromZip(new ZipInputStream(content));
            return fileType;
        }
        finally {
            content.close();
        }
    }

    private static FileType guessTypeFromZip(ZipInputStream zipInputStream) throws IOException {
        ZipEntry entry = zipInputStream.getNextEntry();
        if ("[Content_Types].xml".equals(entry.getName())) {
            String textContents = IOUtils.inputStreamAsString(zipInputStream);
            if (textContents.contains("PartName=\"/word/document.xml\"")) {
                return FileType.docx;
            }
            if (textContents.contains("PartName=\"/ppt/presentation.xml\"")) {
                return FileType.pptx;
            }
            if (textContents.contains("PartName=\"/xl/workbook.xml\"")) {
                return FileType.xlsx;
            }
        }
        return FileType.unknown;
    }
}

