/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MultiMap<K, V>
implements Map<K, Collection<V>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, Collection<V>> delegate;
    private final Class<? extends Collection<V>> collectionClass;

    public MultiMap() {
        this(new LinkedHashMap());
    }

    public MultiMap(Map<K, Collection<V>> delegate) {
        this(delegate, LinkedList.class);
    }

    public MultiMap(Map<K, Collection<V>> delegate, Class<? extends Collection> collectionClass) {
        this.delegate = delegate;
        this.collectionClass = collectionClass;
    }

    public Collection<V> addValue(K key, V value) {
        Collection<V> collection = this.delegate.get(key);
        if (collection == null) {
            collection = this.createCollection();
            this.delegate.put(key, collection);
        }
        collection.add(value);
        return collection;
    }

    public void removeValue(K key, V value) {
        Collection<V> collection = this.delegate.get(key);
        if (collection.remove(value) && collection.size() == 0) {
            this.delegate.remove(key);
        }
    }

    protected Collection<V> createCollection() {
        try {
            return this.collectionClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Collection<V> put(K key, Collection<V> value) {
        return this.delegate.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Collection<V> get(Object key) {
        return this.delegate.get(key);
    }

    public V getFirst(K key) {
        Collection<V> collection = this.delegate.get(key);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.iterator().next();
    }

    @Override
    public Collection<V> remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<V>> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.delegate.keySet();
        if (set == null) {
            MultiMap.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<Collection<V>> values() {
        Collection<Collection<V>> collection = this.delegate.values();
        if (collection == null) {
            MultiMap.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.delegate.entrySet();
    }

    public String toString() {
        return this.entrySet().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/prosc/data/MultiMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

