/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.binding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class ValueHolder<E>
implements PropertyChangeListener {
    private static final Logger log = Logger.getLogger(ValueHolder.class.getName());
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private E value;
    private Class<?> valueClass;
    private Method removeListenerMethod;
    private Method addListenerMethod;

    public ValueHolder(E value) {
        this.value = value;
    }

    public ValueHolder() {
        this(null);
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E newValue) {
        try {
            if (this.value != null && this.removeListenerMethod != null) {
                this.removeListenerMethod.invoke(this.value, this);
            }
            if (newValue != null && newValue.getClass() != this.valueClass) {
                try {
                    this.removeListenerMethod = newValue.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                    this.addListenerMethod = newValue.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                }
                catch (NoSuchMethodException e) {
                    log.fine(newValue.getClass() + " does not support PropertyChangeListeners; events will not be fired");
                    this.removeListenerMethod = null;
                    this.addListenerMethod = null;
                }
                this.valueClass = newValue.getClass();
            }
            if (newValue != null && this.addListenerMethod != null) {
                this.addListenerMethod.invoke(newValue, this);
            }
            this.value = newValue;
            this.changes.firePropertyChange("value", this.value, this.value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.changes.firePropertyChange(evt);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(propertyName, listener);
    }
}

