/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.binding;

import com.prosc.binding.Binding;
import com.prosc.binding.BindingMissingException;
import com.prosc.binding.ValueWriteException;
import com.prosc.shared.ExceptionUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

public class ComponentBinding
extends Binding {
    private static final Logger log = Logger.getLogger(ComponentBinding.class.getName());
    private static Set<Binding.OneWayBinding> currentFocusBindings = new HashSet<Binding.OneWayBinding>(1);
    private boolean disableVerifier = false;
    private ActionListener actionListener;
    private ChangeListener changeListener;
    private ItemListener itemListener;
    private ListSelectionListener listListener;
    private TreeSelectionListener treeListener;
    private ListSelectionListener listModelListener;
    private HierarchyListener hierarchyListener;
    private boolean fireOnKeypress = false;

    public ComponentBinding(Object primaryObject, String primaryProperty, Object component, String componentProperty) {
        super(primaryObject, primaryProperty, component, componentProperty);
    }

    public static void triggerActiveBinding() {
        for (Binding.OneWayBinding binding : currentFocusBindings) {
            ComponentBinding.triggerSecondary(binding);
        }
    }

    @Override
    protected void installListener(Method addListenerMethod, final @Nullable Object installOn, String propertyName, final Binding.OneWayBinding listener) throws ValueWriteException {
        super.installListener(addListenerMethod, installOn, propertyName, listener);
        if (listener.isPrimary()) {
            return;
        }
        boolean didInstallListener = false;
        if (installOn instanceof JTextComponent) {
            final JTextComponent textComponent = (JTextComponent)installOn;
            if (this.fireOnKeypress) {
                didInstallListener = true;
            } else {
                MultiVerifier multiVerifier;
                InputVerifier inputVerifier = textComponent.getInputVerifier();
                try {
                    multiVerifier = (MultiVerifier)inputVerifier;
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("ComponentBinding installs a verifier on the components it is bound to. You cannot use this with a different verifier: " + inputVerifier);
                }
                if (multiVerifier == null) {
                    multiVerifier = new MultiVerifier();
                    ((JComponent)installOn).setInputVerifier(multiVerifier);
                }
                multiVerifier.addBinding(listener);
            }
            textComponent.getDocument().addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent e) {
                    if (ComponentBinding.this.fireOnKeypress || !textComponent.isFocusOwner()) {
                        ComponentBinding.triggerSecondary(listener);
                    }
                }
            });
        }
        if (installOn != null) {
            try {
                try {
                    Method addItemMethod = installOn.getClass().getMethod("addItemListener", ItemListener.class);
                    ItemListener itemListener = new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            ComponentBinding.triggerSecondary(listener);
                        }
                    };
                    addItemMethod.invoke(installOn, itemListener);
                    this.itemListener = itemListener;
                    didInstallListener = true;
                }
                catch (NoSuchMethodException addItemMethod) {
                    // empty catch block
                }
                try {
                    Method addActionMethod = installOn.getClass().getMethod("addActionListener", ActionListener.class);
                    ActionListener actionListener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ComponentBinding.triggerSecondary(listener);
                        }
                    };
                    addActionMethod.invoke(installOn, actionListener);
                    this.actionListener = actionListener;
                    didInstallListener = true;
                }
                catch (NoSuchMethodException addActionMethod) {
                    // empty catch block
                }
                try {
                    Method addListSelectionMethod = installOn.getClass().getMethod("addListSelectionListener", ListSelectionListener.class);
                    ListSelectionListener listListener = new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            if (!e.getValueIsAdjusting()) {
                                ComponentBinding.triggerSecondary(listener);
                            }
                        }
                    };
                    addListSelectionMethod.invoke(installOn, listListener);
                    this.listListener = listListener;
                    didInstallListener = true;
                }
                catch (NoSuchMethodException addListSelectionMethod) {
                    // empty catch block
                }
                try {
                    Method addTreeSelectionMethod = installOn.getClass().getMethod("addTreeSelectionListener", TreeSelectionListener.class);
                    TreeSelectionListener treeListener = new TreeSelectionListener(){

                        @Override
                        public void valueChanged(TreeSelectionEvent e) {
                            ComponentBinding.triggerSecondary(listener);
                        }
                    };
                    addTreeSelectionMethod.invoke(installOn, treeListener);
                    this.treeListener = treeListener;
                    didInstallListener = true;
                }
                catch (NoSuchMethodException addTreeSelectionMethod) {
                    // empty catch block
                }
                if (installOn instanceof JTable) {
                    this.listModelListener = new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            ComponentBinding.triggerSecondary(listener);
                        }
                    };
                    ((JTable)installOn).getSelectionModel().addListSelectionListener(this.listModelListener);
                    didInstallListener = true;
                }
                if (installOn instanceof JSlider) {
                    this.changeListener = new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            ComponentBinding.triggerSecondary(listener);
                        }
                    };
                    ((JSlider)installOn).getModel().addChangeListener(this.changeListener);
                    didInstallListener = true;
                }
                if (installOn instanceof JComponent) {
                    final boolean fireEvents = installOn instanceof JTextComponent || !didInstallListener;
                    ((JComponent)installOn).addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            if (!e.isTemporary()) {
                                currentFocusBindings.add(listener);
                            }
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            if (!e.isTemporary()) {
                                if (fireEvents) {
                                    ComponentBinding.triggerSecondary(listener);
                                }
                                currentFocusBindings.clear();
                            }
                        }
                    });
                    didInstallListener = true;
                }
                if (!didInstallListener) {
                    log.log(Level.WARNING, "Could not find any appropriate type of component listener for object type " + installOn.getClass() + "; will only install property change listener");
                }
                if (installOn instanceof Container) {
                    this.hierarchyListener = new HierarchyListener(){

                        @Override
                        public void hierarchyChanged(HierarchyEvent e) {
                            boolean isDisplayable;
                            if (e.getSource() == installOn && e.getID() == 1400 && (e.getChangeFlags() & 2L) != 0L && !(isDisplayable = ((Component)e.getSource()).isDisplayable())) {
                                ComponentBinding.this.uninstall();
                            }
                        }
                    };
                    ((Container)installOn).addHierarchyListener(this.hierarchyListener);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not add listener to component " + installOn, e);
            }
        }
    }

    @Override
    protected void removeListener(Method removeListenerMethod, Object installOn, PropertyDescriptor property, Binding.OneWayBinding listener) {
        super.removeListener(removeListenerMethod, installOn, property, listener);
        if (listener.isPrimary()) {
            return;
        }
        try {
            if (this.actionListener != null) {
                installOn.getClass().getMethod("removeActionListener", ActionListener.class).invoke(installOn, this.actionListener);
            }
            if (this.changeListener != null) {
                installOn.getClass().getMethod("removeChangeListener", ChangeListener.class).invoke(installOn, this.changeListener);
            }
            if (this.itemListener != null) {
                installOn.getClass().getMethod("removeItemListener", ItemListener.class).invoke(installOn, this.itemListener);
            }
            if (this.listListener != null) {
                installOn.getClass().getMethod("removeListSelectionListener", ListSelectionListener.class).invoke(installOn, this.listListener);
            }
            if (this.treeListener != null) {
                installOn.getClass().getMethod("removeTreeSelectionListener", TreeSelectionListener.class).invoke(installOn, this.treeListener);
            }
            if (this.hierarchyListener != null) {
                installOn.getClass().getMethod("removeHierarchyListener", HierarchyListener.class).invoke(installOn, this.hierarchyListener);
            }
            if (this.listModelListener != null && installOn instanceof JTable) {
                ((JTable)installOn).getSelectionModel().removeListSelectionListener(this.listModelListener);
            }
            if (this.hierarchyListener != null && installOn instanceof Container) {
                ((Container)installOn).removeHierarchyListener(this.hierarchyListener);
            }
            if (installOn instanceof JComponent && ((JComponent)installOn).getInputVerifier() instanceof MultiVerifier) {
                ((JComponent)installOn).setInputVerifier(null);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not remove listener from " + installOn + ", even though adding the listener was successful. This will lead to a memory leak.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean triggerSecondary(Binding.OneWayBinding listener) {
        ComponentBinding binding = (ComponentBinding)listener.getBinding();
        if (!binding.disableVerifier) {
            try {
                binding.disableVerifier = true;
                listener.trigger(true);
                boolean bl = true;
                return bl;
            }
            catch (ValueWriteException e1) {
                binding.handleWriteException(e1);
                try {
                    Object component = binding.getSecondaryBindingEnd().getOriginObject(false);
                    if (component instanceof Component) {
                        ((Component)component).requestFocus();
                    }
                }
                catch (BindingMissingException bindingMissingException) {
                    // empty catch block
                }
                boolean bl = false;
                return bl;
            }
            finally {
                binding.disableVerifier = false;
            }
        }
        return true;
    }

    @Override
    protected void handleWriteException(ValueWriteException e) {
        log.log(Level.SEVERE, e.toString(), e);
        Component c = null;
        try {
            c = (Component)this.getSecondaryBindingEnd().getOriginObject(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c == null) {
            c = JOptionPane.getRootFrame();
        }
        ExceptionUtils.reportAndLogException(Level.SEVERE, c, e.getMessage(), "Could not write value", e);
    }

    public ComponentBinding setFireOnKeypress(boolean fireOnKeypress) {
        this.fireOnKeypress = fireOnKeypress;
        return this;
    }

    private static class MultiVerifier
    extends InputVerifier {
        private Set<Binding.OneWayBinding> bindings = new HashSet<Binding.OneWayBinding>();

        private MultiVerifier() {
        }

        void addBinding(Binding.OneWayBinding trigger) {
            this.bindings.add(trigger);
        }

        @Override
        public boolean verify(JComponent input) {
            boolean result = true;
            for (Binding.OneWayBinding eachBinding : this.bindings) {
                if (ComponentBinding.triggerSecondary(eachBinding)) continue;
                result = false;
            }
            return result;
        }
    }
}

