/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.binding;

import com.prosc.shared.Bool;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;

public class BindingButtonGroup
extends ButtonGroup {
    private static final Logger log = Logger.getLogger(BindingButtonGroup.class.getName());
    private Set<ActionListener> actionListeners = new LinkedHashSet<ActionListener>(3);
    private List<Object[]> links = new LinkedList<Object[]>();
    private Object linkedObject;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public String getSelectedButton() {
        if (this.getSelection() == null) {
            return null;
        }
        Enumeration<AbstractButton> en = this.getElements();
        while (en.hasMoreElements()) {
            AbstractButton eachButton = en.nextElement();
            if (this.getSelection() != eachButton.getModel()) continue;
            return eachButton.getText();
        }
        log.warning("Could not find button matching selected model");
        return null;
    }

    public void setSelectedButton(String buttonTitle) {
        Enumeration<AbstractButton> en = this.getElements();
        while (en.hasMoreElements()) {
            AbstractButton eachButton = en.nextElement();
            boolean selected = buttonTitle != null && buttonTitle.equals(eachButton.getText());
            this.setSelected(eachButton.getModel(), selected);
        }
    }

    @Override
    public void setSelected(ButtonModel m, boolean b) {
        ButtonModel oldValue = this.getSelection();
        super.setSelected(m, b);
        if (b && m != null && m != oldValue) {
            this.updateLinkedObject(m);
            ActionEvent evt = new ActionEvent(m, 0, m.getActionCommand());
            for (ActionListener listener : this.actionListeners) {
                listener.actionPerformed(evt);
            }
        }
    }

    public BindingButtonGroup link(Object object, ButtonModel buttonModel) {
        this.links.add(new Object[]{object, buttonModel});
        return this;
    }

    private void updateLinkedObject(ButtonModel newSelection) {
        Object foundLink = null;
        for (Object[] pairs : this.links) {
            if (pairs[1] != newSelection) continue;
            foundLink = pairs[0];
            break;
        }
        Object oldObject = this.linkedObject;
        this.linkedObject = foundLink;
        this.pcs.firePropertyChange("linkedObject", oldObject, this.linkedObject);
    }

    public void setLinkedObject(Object object) {
        for (Object[] pairs : this.links) {
            if (!Bool.equals(pairs[0], object)) continue;
            super.clearSelection();
            this.setSelected((ButtonModel)pairs[1], true);
        }
        Object oldObject = this.linkedObject;
        this.linkedObject = object;
        this.pcs.firePropertyChange("linkedObject", oldObject, this.linkedObject);
    }

    public Object getLinkedObject() {
        return this.linkedObject;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

