/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.binding;

import com.prosc.binding.BindingCleanup;
import com.prosc.binding.BindingMissingException;
import com.prosc.binding.ValueWriteException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Format;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class Binding {
    private static final Logger log = Logger.getLogger(Binding.class.getName());
    private static final Object[] NO_ARGS = new Object[0];
    private static final PropertyDescriptor ORIGIN_DESC = Binding.getPropertyNamed(OneWayBinding.class, "origin");
    private OneWayBinding primaryBindingStart = null;
    private OneWayBinding primaryBindingEnd = null;
    private PropertyDescriptor primaryDescriptorEnd = null;
    protected OneWayBinding secondaryBindingStart = null;
    private OneWayBinding secondaryBindingEnd = null;
    private PropertyDescriptor secondaryDescriptorEnd = null;
    private Format format = null;
    private boolean formatPrimaryToSecondary;
    private final String primaryProperty;
    private final String secondaryProperty;
    @Nullable
    private Object startingPrimaryObject;
    private Object startingSecondaryObject;
    private String description;
    private boolean hasBeenGCd = false;
    private Map<Object, Object> primaryLinks = new HashMap<Object, Object>();
    private Map<Object, Object> secondaryLinks = new HashMap<Object, Object>();

    public Binding(@Nullable Object primaryObject, String primaryProperty, Object secondaryObject, String secondaryProperty) {
        this.primaryProperty = primaryProperty;
        this.secondaryProperty = secondaryProperty;
        this.startingPrimaryObject = primaryObject;
        this.startingSecondaryObject = secondaryObject;
    }

    protected void writeToPrimary(PropertyDescriptor property, Object target, Object oldValue, Object newValue) throws ParseException, InvocationTargetException {
        Object convertedValue;
        block16: {
            if (this.secondaryLinks.containsKey(newValue)) {
                convertedValue = this.secondaryLinks.get(newValue);
            } else {
                Class<?> type = property.getPropertyType();
                if (this.format == null) {
                    convertedValue = this.convertTo(newValue, type);
                } else {
                    try {
                        if (this.formatPrimaryToSecondary) {
                            try {
                                convertedValue = this.format.parseObject((String)newValue);
                                break block16;
                            }
                            catch (ParseException e) {
                                if (((String)newValue).length() == 0) {
                                    convertedValue = null;
                                    break block16;
                                }
                                throw e;
                            }
                        }
                        convertedValue = this.format.format(newValue);
                    }
                    catch (RuntimeException e) {
                        if (newValue == null) {
                            convertedValue = null;
                        }
                        throw e;
                    }
                }
            }
        }
        if (!this.strictEquals(oldValue, convertedValue)) {
            try {
                property.getWriteMethod().invoke(target, convertedValue);
            }
            catch (IllegalArgumentException e) {
                if (convertedValue != null) {
                    throw e;
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            this.didChange();
        }
    }

    private boolean strictEquals(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        if (value1.getClass() != value2.getClass()) {
            return false;
        }
        if (value1 instanceof Boolean || value1 instanceof Number || value1 instanceof String) {
            return value1.equals(value2);
        }
        return false;
    }

    protected void writeToSecondary(PropertyDescriptor property, Object target, Object oldValue, Object newValue) throws InvocationTargetException, IllegalAccessException, ParseException {
        Object convertedValue;
        block14: {
            if (this.primaryLinks.containsKey(newValue)) {
                convertedValue = this.primaryLinks.get(newValue);
            } else {
                Class<?> type = property.getPropertyType();
                if (this.format == null) {
                    convertedValue = this.convertTo(newValue, type);
                } else {
                    try {
                        if (this.formatPrimaryToSecondary) {
                            convertedValue = this.format.format(newValue);
                            break block14;
                        }
                        try {
                            convertedValue = this.format.parseObject((String)newValue);
                        }
                        catch (ParseException e) {
                            if (((String)newValue).length() == 0) {
                                convertedValue = null;
                                break block14;
                            }
                            throw e;
                        }
                    }
                    catch (RuntimeException e) {
                        if (newValue == null) {
                            convertedValue = null;
                        }
                        throw e;
                    }
                }
            }
        }
        if (!this.strictEquals(oldValue, convertedValue)) {
            try {
                property.getWriteMethod().invoke(target, convertedValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.didChange();
    }

    protected Object convertTo(Object value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == type) {
            return value;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value.getClass() == String.class) {
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            if (editor != null) {
                block23: {
                    try {
                        editor.setAsText((String)value);
                    }
                    catch (IllegalArgumentException e) {
                        if (((String)value).length() != 0) break block23;
                        editor.setValue(null);
                    }
                }
                return editor.getValue();
            }
            if (type == Integer.class) {
                return Integer.parseInt((String)value);
            }
            if (type == Long.class) {
                return Long.parseLong((String)value);
            }
            if (type == Float.class) {
                return Float.valueOf(Float.parseFloat((String)value));
            }
            if (type == Double.class) {
                return Double.parseDouble((String)value);
            }
            if (type == Byte.class) {
                return Byte.parseByte((String)value);
            }
            if (type == Short.class) {
                return Short.parseShort((String)value);
            }
        } else {
            if (type == String.class) {
                PropertyEditor editor = PropertyEditorManager.findEditor(value.getClass());
                if (editor == null) {
                    return String.valueOf(value);
                }
                editor.setValue(value);
                return editor.getAsText();
            }
            if (type.isPrimitive() && value instanceof Number) {
                if (type == Byte.TYPE) {
                    return ((Number)value).byteValue();
                }
                if (type == Short.TYPE) {
                    return ((Number)value).shortValue();
                }
                if (type == Integer.TYPE) {
                    return ((Number)value).intValue();
                }
                if (type == Long.TYPE) {
                    return ((Number)value).longValue();
                }
                if (type == Float.TYPE) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                if (type == Double.TYPE) {
                    return ((Number)value).doubleValue();
                }
            }
        }
        return value;
    }

    protected void handleWriteException(ValueWriteException e) {
        log.log(Level.SEVERE, e.toString(), e);
    }

    public void setFormat(Format format, boolean formatPrimaryToSecondary) {
        this.format = format;
        this.formatPrimaryToSecondary = formatPrimaryToSecondary;
    }

    protected void installListener(Method addListenerMethod, @Nullable Object installOn, String propertyName, OneWayBinding listener) throws ValueWriteException {
        if (addListenerMethod != null && installOn != null) {
            try {
                if (addListenerMethod.getParameterTypes().length == 1) {
                    addListenerMethod.invoke(installOn, listener);
                } else {
                    addListenerMethod.invoke(installOn, propertyName, listener);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not add listener to " + installOn, e);
            }
        }
    }

    protected void removeListener(Method removeListenerMethod, Object installOn, PropertyDescriptor property, OneWayBinding listener) {
        if (removeListenerMethod != null && installOn != null) {
            try {
                if (removeListenerMethod.getParameterTypes().length == 1) {
                    removeListenerMethod.invoke(installOn, listener);
                } else {
                    removeListenerMethod.invoke(installOn, property.getName(), listener);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not remove listener from " + installOn, e);
            }
        }
    }

    public OneWayBinding getPrimaryBindingEnd() {
        return this.primaryBindingEnd;
    }

    public OneWayBinding getSecondaryBindingEnd() {
        return this.secondaryBindingEnd;
    }

    public Binding link(Object primaryValue, Object secondaryValue) {
        this.primaryLinks.put(primaryValue, secondaryValue);
        this.secondaryLinks.put(secondaryValue, primaryValue);
        return this;
    }

    public void linkIndexPrimary(Object ... indexedValue) {
        for (int n = 0; n < indexedValue.length; ++n) {
            this.link(n, indexedValue[n]);
        }
    }

    public void linkIndexSecondary(Object ... indexedValue) {
        for (int n = 0; n < indexedValue.length; ++n) {
            this.link(indexedValue[n], n);
        }
    }

    public void linkBooleanPrimary(Object trueValue, Object falseValue) {
        this.link(Boolean.TRUE, trueValue);
        this.link(Boolean.FALSE, falseValue);
    }

    public void linkBooleanSecondary(Object trueValue, Object falseValue) {
        this.link(trueValue, Boolean.TRUE);
        this.link(trueValue, Boolean.FALSE);
    }

    public static PropertyDescriptor getPropertyNamed(Class<?> targetClass, String name) {
        try {
            return Binding.getPropertyNamed(Introspector.getBeanInfo(targetClass), name);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static PropertyDescriptor getPropertyNamed(BeanInfo targetInfo, String name) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = targetInfo.getPropertyDescriptors()) {
            if (!name.equals(descriptor.getName())) continue;
            return descriptor;
        }
        throw new IntrospectionException("No property exists with name: " + name + " for " + targetInfo.getBeanDescriptor().getBeanClass());
    }

    public final void uninstall() {
        if (this.startingSecondaryObject == null) {
            OneWayBinding[] bindingsToUninstall;
            try {
                this.startingPrimaryObject = this.primaryBindingStart.getOriginObject(false);
                this.startingSecondaryObject = this.secondaryBindingStart.getOriginObject(false);
            }
            catch (BindingMissingException e) {
                this.startingPrimaryObject = null;
                this.startingSecondaryObject = null;
                this.hasBeenGCd = true;
            }
            for (OneWayBinding currentBinding : bindingsToUninstall = new OneWayBinding[]{this.secondaryBindingStart, this.primaryBindingStart}) {
                try {
                    currentBinding.setOrigin(null);
                }
                catch (ValueWriteException e) {
                    log.log(Level.WARNING, "Could not write a null value to " + currentBinding + " to uninstall it.", e);
                }
            }
        }
    }

    protected void didChange() {
    }

    public final Binding install() {
        if (this.hasBeenGCd) {
            throw new IllegalStateException("Cannot restore this old binding because one of its ends was previously garbage collected.");
        }
        if (this.startingSecondaryObject != null) {
            String primaryObjectDescription = this.startingPrimaryObject == null ? "null" : this.startingPrimaryObject.getClass().getName();
            this.description = primaryObjectDescription + "." + this.primaryProperty + "<->" + this.startingSecondaryObject.getClass().getName() + "." + this.secondaryProperty;
            this.primaryBindingStart = new OneWayBinding(this.primaryProperty, true, true);
            this.secondaryBindingStart = new OneWayBinding(this.secondaryProperty, false, true);
            try {
                this.secondaryBindingStart.setOrigin(this.startingSecondaryObject);
            }
            catch (ValueWriteException e) {
                log.log(Level.WARNING, "Could not set the initial value (" + e.getNewValue() + ") from the secondary object " + this.startingSecondaryObject + " on binding " + this.description, e);
            }
            if (this.startingPrimaryObject != null) {
                try {
                    this.primaryBindingStart.setOrigin(this.startingPrimaryObject);
                }
                catch (ValueWriteException e) {
                    log.log(Level.WARNING, "Could not set the initial value (" + e.getNewValue() + ") from the primary object " + this.startingPrimaryObject + " on binding " + this.description, e);
                }
            }
            this.startingPrimaryObject = null;
            this.startingSecondaryObject = null;
        }
        return this;
    }

    public String toString() {
        return this.description;
    }

    class BindingReference
    extends WeakReference<Object> {
        public BindingReference(Object referent, ReferenceQueue<? super Object> q) {
            super(referent, q);
        }

        void wasGarbageCollected() {
            log.info("Cleanup up unused binding: " + Binding.this.description);
            Binding.this.uninstall();
        }
    }

    class OneWayBinding
    implements PropertyChangeListener,
    VetoableChangeListener {
        private final boolean isEndOfChain;
        private final boolean isStartOfChain;
        private final OneWayBinding nextInChain;
        private final String targetPropertyName;
        private final String targetPathRemainder;
        private final boolean isPrimary;
        private WeakReference<?> originObjectRef = null;
        private Class<?> originClass;
        private PropertyDescriptor originProperty;
        private Method addListenerMethod;
        private Method removeListenerMethod;
        private boolean isBindingByName = false;
        private boolean ignoreExternalEvents = false;

        OneWayBinding(String targetPath, boolean isPrimary, boolean isStartOfChain) {
            this.isStartOfChain = isStartOfChain;
            this.isPrimary = isPrimary;
            int mark = targetPath.indexOf(46);
            if (mark >= 0) {
                this.targetPropertyName = targetPath.substring(0, mark);
                this.targetPathRemainder = targetPath.substring(mark + 1);
                this.isEndOfChain = false;
                this.nextInChain = new OneWayBinding(this.targetPathRemainder, isPrimary, false);
            } else {
                this.targetPropertyName = targetPath;
                this.isEndOfChain = true;
                if (isPrimary) {
                    Binding.this.primaryBindingEnd = this;
                } else {
                    Binding.this.secondaryBindingEnd = this;
                }
                this.targetPathRemainder = null;
                this.nextInChain = null;
            }
        }

        public Binding getBinding() {
            return Binding.this;
        }

        private PropertyDescriptor getTargetProperty() {
            if (this.isEndOfChain) {
                return this.isPrimary ? Binding.this.secondaryDescriptorEnd : Binding.this.primaryDescriptorEnd;
            }
            return ORIGIN_DESC;
        }

        private Object getTargetObject() throws BindingMissingException {
            if (this.isEndOfChain) {
                if (this.isPrimary) {
                    return Binding.this.secondaryBindingEnd == null ? null : Binding.this.secondaryBindingEnd.getOriginObject(true);
                }
                return Binding.this.primaryBindingEnd == null ? null : Binding.this.primaryBindingEnd.getOriginObject(true);
            }
            return this.nextInChain;
        }

        public boolean isPrimary() {
            return this.isPrimary;
        }

        public void setOrigin(@Nullable Object newOrigin) throws ValueWriteException {
            Object oldOriginValue = null;
            try {
                oldOriginValue = this.getOriginObject(false);
            }
            catch (BindingMissingException bindingMissingException) {
                // empty catch block
            }
            if (oldOriginValue == newOrigin) {
                return;
            }
            Binding.this.removeListener(this.removeListenerMethod, oldOriginValue, this.originProperty, this);
            if (newOrigin != null && newOrigin.getClass() != this.originClass) {
                this.originClass = newOrigin.getClass();
                this.originProperty = Binding.getPropertyNamed(this.originClass, this.targetPropertyName);
                if (this.isEndOfChain) {
                    if (this.isPrimary) {
                        Binding.this.primaryDescriptorEnd = this.originProperty;
                    } else {
                        Binding.this.secondaryDescriptorEnd = this.originProperty;
                    }
                }
                if (!this.originProperty.isConstrained()) {
                    try {
                        this.addListenerMethod = this.originClass.getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                        this.removeListenerMethod = this.originClass.getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
                        this.isBindingByName = true;
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            this.addListenerMethod = this.originClass.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                            this.removeListenerMethod = this.originClass.getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                            this.isBindingByName = false;
                        }
                        catch (NoSuchMethodException e1) {
                            log.info("The class " + this.originClass.getName() + " does not support property listeners. No PropertyChangeListeners will be installed on it.");
                        }
                    }
                }
            }
            this.originObjectRef = newOrigin == null ? null : new BindingReference(newOrigin, BindingCleanup.bindingRefs);
            if (this.isPrimary || !this.isEndOfChain) {
                this.trigger(false);
            }
            Binding.this.installListener(this.addListenerMethod, newOrigin, this.originProperty.getName(), this);
        }

        public Object getOriginObject(boolean startFromTopOfChain) throws BindingMissingException {
            if (startFromTopOfChain && !this.isStartOfChain) {
                this.ignoreExternalEvents = true;
                try {
                    if (this.isPrimary) {
                        Binding.this.primaryBindingStart.refreshOriginObjectRecursively(Binding.this.primaryBindingStart.getOriginObject(false));
                    } else {
                        Binding.this.secondaryBindingStart.refreshOriginObjectRecursively(Binding.this.primaryBindingStart.getOriginObject(false));
                    }
                }
                finally {
                    this.ignoreExternalEvents = false;
                }
            }
            if (Binding.this.hasBeenGCd) {
                throw new BindingMissingException(this.toString() + " has been garbage collected");
            }
            if (this.originObjectRef == null) {
                return null;
            }
            Object result = this.originObjectRef.get();
            if (this.originObjectRef.isEnqueued() || result == null) {
                log.info("Attempt was made to trigger binding after one of the ends of the binding has been garbage collected. This trigger will be ignored.");
                Binding.this.hasBeenGCd = true;
                BindingCleanup.triggerCleanup();
                Binding.this.uninstall();
                throw new BindingMissingException(this.toString() + " has been garbage collected");
            }
            return result;
        }

        private void refreshOriginObjectRecursively(Object newOriginObject) {
            try {
                this.setOrigin(newOriginObject);
            }
            catch (ValueWriteException e) {
                throw new RuntimeException(e);
            }
            if (!this.isEndOfChain) {
                this.nextInChain.refreshOriginObjectRecursively(this.readValueFromOrigin(newOriginObject));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.ignoreExternalEvents && (this.isBindingByName || this.originProperty.getName().equals(evt.getPropertyName()))) {
                try {
                    this.ignoreExternalEvents = true;
                    this.setTargetValue(evt.getNewValue());
                }
                catch (InvocationTargetException e) {
                    Binding.this.handleWriteException(new ValueWriteException(this.getTargetProperty(), evt.getNewValue(), e.getCause()));
                }
                catch (BindingMissingException bindingMissingException) {
                }
                finally {
                    this.ignoreExternalEvents = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (!this.ignoreExternalEvents && (this.isBindingByName || this.originProperty.getName().equals(evt.getPropertyName()))) {
                Object targetObject = null;
                try {
                    this.ignoreExternalEvents = true;
                    targetObject = this.getTargetObject();
                    this.setTargetValue(evt.getNewValue());
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof PropertyVetoException) {
                        throw (PropertyVetoException)e.getCause();
                    }
                    String msg = "Could not write value (" + evt.getNewValue() + ") to property '" + this.getTargetProperty().getName() + "' of " + targetObject + " because of " + e.getTargetException().toString() + "; PropertyVetoException will be thrown";
                    throw new PropertyVetoException(msg, evt);
                }
                catch (BindingMissingException bindingMissingException) {
                }
                finally {
                    this.ignoreExternalEvents = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trigger(boolean startFromTopOfChain) throws ValueWriteException {
            if (!this.ignoreExternalEvents) {
                try {
                    this.ignoreExternalEvents = true;
                    Object newValue = null;
                    if (this.originProperty.getReadMethod() != null) {
                        Object originObject = this.getOriginObject(false);
                        if (originObject != null) {
                            newValue = this.readValueFromOrigin(originObject);
                        }
                        if (startFromTopOfChain && !this.isStartOfChain) {
                            this.getOriginObject(true);
                        }
                    }
                    if (this.getTargetObject() == null) {
                        return;
                    }
                    try {
                        this.setTargetValue(newValue);
                    }
                    catch (InvocationTargetException e) {
                        throw new ValueWriteException(this.getTargetProperty(), newValue, e.getTargetException());
                    }
                    catch (IllegalArgumentException e) {
                        throw new ValueWriteException(e.getMessage(), this.getTargetProperty(), newValue, e);
                    }
                    catch (Throwable t) {
                        throw new ValueWriteException(this.getTargetProperty(), newValue, t);
                    }
                }
                catch (BindingMissingException bindingMissingException) {
                }
                finally {
                    this.ignoreExternalEvents = false;
                }
            }
        }

        private Object readValueFromOrigin(Object originObject) {
            if (originObject == null || this.originProperty.getReadMethod() == null) {
                return null;
            }
            try {
                return this.originProperty.getReadMethod().invoke(originObject, NO_ARGS);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not read property " + this.originProperty + " from " + originObject + " because of an IllegalAccessException", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Attempt to read property " + this.originProperty + " from " + originObject + " failed", e.getTargetException());
            }
            catch (RuntimeException e) {
                throw e;
            }
        }

        private void setTargetValue(Object newValue) throws InvocationTargetException, BindingMissingException {
            if (this.getTargetObject() == null) {
                throw new IllegalArgumentException("setTargetValue() was called with a null targetObject while trying to set " + this.targetPropertyName + (this.targetPathRemainder == null ? "" : "." + this.targetPathRemainder) + " from " + this.originClass);
            }
            if (this.getTargetProperty().getWriteMethod() == null) {
                log.log(Level.FINE, this.getTargetObject() + "." + this.getTargetProperty().getName() + " is not writable");
                return;
            }
            try {
                Method targetReadMethod = this.getTargetProperty().getReadMethod();
                if (this == Binding.this.primaryBindingEnd) {
                    Object oldValue = targetReadMethod == null ? null : targetReadMethod.invoke(this.getTargetObject(), new Object[0]);
                    Binding.this.writeToSecondary(this.getTargetProperty(), this.getTargetObject(), oldValue, newValue);
                } else if (this == Binding.this.secondaryBindingEnd) {
                    if (!((Binding)Binding.this).primaryBindingEnd.ignoreExternalEvents) {
                        Object oldValue = targetReadMethod == null ? null : targetReadMethod.invoke(this.getTargetObject(), new Object[0]);
                        Binding.this.writeToPrimary(this.getTargetProperty(), this.getTargetObject(), oldValue, newValue);
                    }
                } else {
                    this.getTargetProperty().getWriteMethod().invoke(this.getTargetObject(), newValue);
                    Binding.this.didChange();
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not write property " + this.getTargetProperty() + " of " + this.getTargetObject() + " because of an IllegalAccessException", e);
            }
            catch (IllegalArgumentException e) {
                if ("argument type mismatch".equals(e.getMessage()) || e.getMessage() != null && e.getMessage().startsWith("java.lang.ClassCastException")) {
                    throw new IllegalArgumentException("Cannot write \"" + newValue + "\" with type " + newValue.getClass() + " to property " + this.getTargetObject().getClass() + "." + this.getTargetProperty().getName());
                }
                throw e;
            }
            catch (ParseException e) {
                throw new InvocationTargetException(e);
            }
        }

        public String toString() {
            String originObjectName = this.originClass == null ? "<unknown class>" : this.originClass.getName();
            String originPropertyName = this.originProperty == null ? "<unknown origin property>" : this.originProperty.getName();
            PropertyDescriptor targetProperty = this.getTargetProperty();
            String targetObjectName = targetProperty == null ? "<unknown target property>" : ValueWriteException.classForProperty(targetProperty).getName();
            return (this.isPrimary ? "(primary) " : "(secondary) ") + originObjectName + "." + originPropertyName + " -> " + targetObjectName + "." + this.targetPropertyName;
        }
    }
}

