/*
 * Decompiled with CFR 0.152.
 */
package com.prosc;

import java.io.File;
import org.jetbrains.annotations.NotNull;

public enum Platform {
    mac(true),
    windows(false),
    linux(true),
    unknown(true);

    public static final Platform current;
    public final boolean unixLike;

    private Platform(boolean unixLike) {
        this.unixLike = unixLike;
    }

    public static boolean isMac() {
        return current == mac;
    }

    public static boolean isWin() {
        return current == windows;
    }

    public static boolean isLin() {
        return current == linux;
    }

    public String pathTranslated(@NotNull String pathFromOtherPlatform) {
        Platform origin;
        if (pathFromOtherPlatform == null) {
            Platform.$$$reportNull$$$0(0);
        }
        if ((origin = Platform.analyzePath(pathFromOtherPlatform)) == this) {
            return pathFromOtherPlatform;
        }
        switch (origin) {
            case unknown: {
                return pathFromOtherPlatform;
            }
            case mac: 
            case linux: {
                if (this == windows) {
                    String backslashed = pathFromOtherPlatform.replace("\\", ":").replace("/", "\\");
                    return backslashed.substring(1).replaceFirst("\\\\", ":\\\\");
                }
                return pathFromOtherPlatform;
            }
            case windows: {
                return "/" + pathFromOtherPlatform.replace("/", ":").replace("\\", "/").replaceFirst("\\:/", "/");
            }
        }
        return pathFromOtherPlatform;
    }

    @NotNull
    private static Platform analyzePath(@NotNull String pathFromOtherPlatform) {
        if (pathFromOtherPlatform == null) {
            Platform.$$$reportNull$$$0(1);
        }
        if (pathFromOtherPlatform.startsWith("/")) {
            Platform platform = mac;
            if (platform == null) {
                Platform.$$$reportNull$$$0(2);
            }
            return platform;
        }
        if (pathFromOtherPlatform.contains(":\\")) {
            Platform platform = windows;
            if (platform == null) {
                Platform.$$$reportNull$$$0(3);
            }
            return platform;
        }
        Platform platform = unknown;
        if (platform == null) {
            Platform.$$$reportNull$$$0(4);
        }
        return platform;
    }

    public static File getApplicationDataDirForUser() {
        if (Platform.isMac()) {
            return new File(System.getProperty("user.home"), "Library/Application Support");
        }
        if (Platform.isWin()) {
            return new File(System.getenv("APPDATA"));
        }
        if (Platform.isLin()) {
            return new File(System.getProperty("user.home"));
        }
        throw new IllegalStateException("Unrecognized platform");
    }

    public static File getApplicationDataDirForSystem() {
        if (Platform.isMac()) {
            return new File("/Library/Application Support");
        }
        if (Platform.isWin()) {
            return new File(System.getenv("PROGRAMDATA"));
        }
        if (Platform.isLin()) {
            return new File(System.getProperty("user.home"));
        }
        throw new IllegalStateException("Unrecognized platform");
    }

    static {
        String osName = System.getProperty("os.name");
        current = osName == null ? unknown : (osName.startsWith("Mac") ? mac : (osName.startsWith("Windows") ? windows : (osName.startsWith("Linux") ? linux : unknown)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFromOtherPlatform";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/prosc/Platform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/prosc/Platform";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pathTranslated";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "analyzePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

