/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.thread;

import com.prosc.shared.ExceptionUtils;
import com.prosc.thread.MyThreadFactory;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class TimeoutTask {
    private static final Logger log = Logger.getLogger(TimeoutTask.class.getName());

    public final void doWithTimeout(Runnable runnable, int timeoutMilliseconds, String threadName) throws InterruptedException, TimeoutException {
        Thread worker = new Thread(runnable, threadName);
        worker.start();
        try {
            if (timeoutMilliseconds <= 0) {
                worker.join();
            } else {
                worker.join(timeoutMilliseconds);
                if (worker.isAlive()) {
                    this.onTimeout(worker);
                    throw new TimeoutException("Timeout task '" + threadName + "' did not finish within " + timeoutMilliseconds + " milliseconds.");
                }
            }
        }
        catch (InterruptedException e) {
            worker.interrupt();
            throw e;
        }
    }

    public final <T> T doWithTimeout(Callable<T> callable, int timeoutMilliseconds, String threadName) throws InterruptedException, TimeoutException, ExecutionException {
        ExecutorService singleThreadService = Executors.newSingleThreadExecutor(new MyThreadFactory(threadName, true));
        try {
            Future<T> future = singleThreadService.submit(callable);
            if (timeoutMilliseconds <= 0) {
                T t = future.get();
                return t;
            }
            T t = future.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            return t;
        }
        finally {
            singleThreadService.shutdown();
        }
    }

    public final <T> T doWithTimeoutSingleThreaded(Callable<T> callable, int timeoutMilliseconds) {
        return this.doWithTimeoutSingleThreaded(callable, timeoutMilliseconds, RuntimeException.class, RuntimeException.class);
    }

    public final <T, E1 extends Throwable> T doWithTimeoutSingleThreaded(Callable<T> callable, int timeoutMilliseconds, Class<E1> exceptionClass1) throws E1 {
        return this.doWithTimeoutSingleThreaded(callable, timeoutMilliseconds, exceptionClass1, RuntimeException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T, E1 extends Throwable, E2 extends Throwable> T doWithTimeoutSingleThreaded(Callable<T> callable, final int timeoutMilliseconds, Class<E1> exceptionClass1, Class<E2> exceptionClass2) throws E1, E2 {
        final Date timeoutDate = new Date(System.currentTimeMillis() + (long)timeoutMilliseconds);
        final Object lock = new Object();
        final Thread mainThread = Thread.currentThread();
        final boolean[] finished = new boolean[]{false};
        Thread timeoutThread = new Thread("Timeout thread will wait until " + timeoutDate.toString()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = lock;
                    synchronized (object) {
                        while (!finished[0]) {
                            long waitTime = Math.min(timeoutDate.getTime() - System.currentTimeMillis(), 1L);
                            lock.wait(waitTime);
                            if (finished[0] || System.currentTimeMillis() < timeoutDate.getTime()) continue;
                            log.warning("Main thread " + mainThread.getName() + " did not finish within timeout period of " + timeoutMilliseconds + "; will call onTimeout() method to interrupt it.");
                            TimeoutTask.this.onTimeout(mainThread);
                            break;
                        }
                    }
                }
                catch (InterruptedException e) {
                    log.warning("Timeout thread was interrupted; it will not trigger an interrupt() in the main thread");
                }
            }
        };
        timeoutThread.setDaemon(true);
        timeoutThread.setPriority(1);
        timeoutThread.start();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            if (exceptionClass1.isAssignableFrom(e.getClass())) {
                throw e;
            }
            if (exceptionClass2.isAssignableFrom(e.getClass())) {
                throw e;
            }
            throw ExceptionUtils.rethrowUnchecked(e);
        }
        finally {
            Object object = lock;
            synchronized (object) {
                finished[0] = true;
                lock.notifyAll();
            }
        }
    }

    protected void onTimeout(Thread worker) {
        worker.interrupt();
    }
}

