/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing.editors;

import java.awt.Component;
import java.awt.FlowLayout;
import java.beans.PropertyEditorSupport;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpinnerEditor
extends PropertyEditorSupport {
    private final JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
    private final JSpinner spinner;

    public SpinnerEditor(final JSpinner spinner) {
        this.spinner = spinner;
        this.panel.add(this.spinner);
        spinner.addChangeListener(new ChangeListener(){
            public boolean ignoreEvents;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!this.ignoreEvents) {
                    this.ignoreEvents = true;
                    try {
                        SpinnerEditor.this.setValue(spinner.getValue());
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ignoreEvents = false;
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
        });
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.spinner.setValue(value);
    }

    @Override
    public Object getValue() {
        return this.spinner.getValue();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.panel;
    }
}

