/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ByteArrayEditor
implements PropertyEditor {
    private Set listeners = new HashSet(1);
    private JLabel label = new JLabel();
    private byte[] bytes;

    @Override
    public void setValue(Object value) {
        if (!(value instanceof byte[])) {
            throw new IllegalArgumentException("You can only use byte arrays with the ByteArrayEditor");
        }
        byte[] oldValue = this.bytes;
        this.bytes = (byte[])value;
        try {
            this.label.setIcon(new ImageIcon(this.bytes));
        }
        catch (Exception e) {
            this.label = new JLabel(this.bytes.toString());
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, null, oldValue, this.bytes);
        this.firePropertyChangeEvent(evt);
    }

    @Override
    public Object getValue() {
        return this.bytes;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        return Base64.getEncoder().encodeToString(this.bytes);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        byte[] array = Base64.getDecoder().decode(text);
        this.setValue(array);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return this.label;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent evt) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((PropertyChangeListener)it.next()).propertyChange(evt);
        }
    }
}

