/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class ScrollableWrapper
extends JComponent
implements Scrollable {
    private boolean trackViewportWidth;
    private boolean trackViewportHeight;
    private int scrollableUnitFraction = 10;

    public ScrollableWrapper(Component content, boolean trackViewportWidth, boolean trackViewportHeight) {
        this.trackViewportHeight = trackViewportHeight;
        this.trackViewportWidth = trackViewportWidth;
        this.setLayout(new BorderLayout());
        this.add(content);
    }

    public void setScrollableUnitFraction(int scrollableUnitFraction) {
        this.scrollableUnitFraction = scrollableUnitFraction;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int extent = orientation == 1 ? visibleRect.height : visibleRect.width;
        return extent / this.scrollableUnitFraction;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.trackViewportWidth;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.trackViewportHeight;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (this.getParent() instanceof JViewport) {
            int viewPortHeight;
            JViewport port = (JViewport)this.getParent();
            if (!this.getScrollableTracksViewportHeight() && (viewPortHeight = port.getHeight()) > this.getMinimumSize().height) {
                result.height = viewPortHeight;
            }
        }
        return result;
    }
}

