/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.beans.BeanUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class PropertyTableModel
implements TableModel,
ListDataListener {
    private ListModel objects;
    private PropertyDescriptorGroup properties;
    private static final Object[] noArgs = new Object[0];
    private Set tableListeners = new HashSet(1);
    private boolean hasListeners = false;

    public PropertyTableModel(ListModel objects, PropertyDescriptorGroup properties) {
        this.objects = objects;
        this.properties = properties;
        objects.addListDataListener(this);
    }

    public void setListModel(ListModel model) {
        this.objects = model;
        TableModelEvent event = new TableModelEvent(this);
        this.fireContentsChanged(event);
    }

    public ListModel getListModel() {
        return this.objects;
    }

    @Override
    public int getRowCount() {
        return this.objects.getSize();
    }

    @Override
    public int getColumnCount() {
        return this.properties.getEnabledProperties().size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        try {
            PropertyDescriptor prop = (PropertyDescriptor)this.properties.getEnabledProperties().get(columnIndex);
            return prop.getDisplayName();
        }
        catch (IndexOutOfBoundsException e) {
            return " ";
        }
    }

    public Class getColumnClass(int columnIndex) {
        try {
            PropertyDescriptor prop = (PropertyDescriptor)this.properties.getEnabledProperties().get(columnIndex);
            return prop.getPropertyType();
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        try {
            PropertyDescriptor prop = (PropertyDescriptor)this.properties.getEnabledProperties().get(columnIndex);
            return prop.getWriteMethod() != null;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object listObject = this.objects.getElementAt(rowIndex);
        try {
            PropertyDescriptor prop = (PropertyDescriptor)this.properties.getEnabledProperties().get(columnIndex);
            try {
                Object result = prop.getReadMethod().invoke(listObject, noArgs);
                Format format = (Format)prop.getValue("format");
                return format == null ? result : format.format(result);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object listObject = this.objects.getElementAt(rowIndex);
        PropertyDescriptor prop = (PropertyDescriptor)this.properties.getEnabledProperties().get(columnIndex);
        try {
            prop.getWriteMethod().invoke(listObject, aValue);
            if (this.hasListeners) {
                TableModelEvent event = new TableModelEvent(this, rowIndex, rowIndex, columnIndex);
                this.fireContentsChanged(event);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableListeners.add(l);
        this.hasListeners = this.tableListeners.size() > 0;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableListeners.remove(l);
        this.hasListeners = this.tableListeners.size() > 0;
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (this.hasListeners) {
            TableModelEvent tableEvent = new TableModelEvent(this, e.getIndex0(), e.getIndex1(), -1, 1);
            for (TableModelListener listener : this.tableListeners) {
                listener.tableChanged(tableEvent);
            }
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (this.hasListeners) {
            TableModelEvent tableEvent = new TableModelEvent(this, e.getIndex0(), e.getIndex1(), -1, -1);
            for (TableModelListener listener : this.tableListeners) {
                listener.tableChanged(tableEvent);
            }
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (this.hasListeners) {
            TableModelEvent tableEvent = new TableModelEvent(this, e.getIndex0(), e.getIndex1(), -1, 0);
            this.fireContentsChanged(tableEvent);
        }
    }

    private void fireContentsChanged(TableModelEvent tableEvent) {
        for (TableModelListener listener : this.tableListeners) {
            listener.tableChanged(tableEvent);
        }
    }

    public static class PropertyDescriptorGroup {
        private BeanInfo beanInfo;
        private List properties;
        private List enabledProperties;
        private Set disabledProperties;

        public PropertyDescriptorGroup(BeanInfo beanInfo, boolean addAllProperties) {
            this.beanInfo = beanInfo;
            if (addAllProperties) {
                this.setProperties(Arrays.asList(beanInfo.getPropertyDescriptors()));
            } else {
                this.setProperties(new ArrayList());
            }
        }

        public List getProperties() {
            return this.properties;
        }

        public void setProperties(List input) {
            this.properties = input;
            this.disabledProperties = new HashSet();
            this.enabledProperties = null;
        }

        public void addProperty(PropertyDescriptor prop) {
            this.properties.add(prop);
            this.enabledProperties = null;
        }

        public PropertyDescriptor addProperty(String propertyName, String userPresentableName, Format formatter) throws IntrospectionException {
            PropertyDescriptor prop = BeanUtils.getPropertyNamed(this.beanInfo, propertyName);
            if (userPresentableName != null) {
                prop.setDisplayName(userPresentableName);
            }
            if (formatter != null) {
                prop.setValue("format", formatter);
            }
            this.addProperty(prop);
            return prop;
        }

        public void disableProperty(PropertyDescriptor whichProperty) {
            this.disabledProperties.add(whichProperty);
            this.enabledProperties = null;
        }

        public void enableProperty(PropertyDescriptor whichProperty) {
            this.disabledProperties.remove(whichProperty);
            this.enabledProperties = null;
        }

        public boolean isPropertyEnabled(PropertyDescriptor whichProperty) {
            return !this.disabledProperties.contains(whichProperty);
        }

        public List getEnabledProperties() {
            if (this.enabledProperties == null) {
                this.enabledProperties = new ArrayList(this.properties);
                this.enabledProperties.removeAll(this.disabledProperties);
            }
            return this.enabledProperties;
        }
    }
}

