/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.swing.DefaultHyperlinkListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.View;
import javax.swing.text.html.HTML;

public class HyperlinkMouseAdapter
extends MouseAdapter {
    private static final Logger log = Logger.getLogger(HyperlinkMouseAdapter.class.getName());
    private final HyperlinkListener listener;
    private Element[] clickableElements = null;
    private AccessibleText text = null;
    private Element currentElement = null;

    public HyperlinkMouseAdapter(JComponent component) {
        this(component, new DefaultHyperlinkListener());
    }

    public HyperlinkMouseAdapter(JComponent component, HyperlinkListener listener) {
        AccessibleContext accessibleContext = component.getAccessibleContext();
        if (accessibleContext == null) {
            log.warning("JComponent " + component + " returned null for accessible context; cannot install a HyperlinkMouseAdapter on it.");
            this.listener = null;
        } else {
            AccessibleText text = accessibleContext.getAccessibleText();
            if (text == null) {
                log.warning("JComponent " + component + " has null for accessible text; cannot install a HyperlinkMouseAdapter on it.");
                this.listener = null;
            } else {
                View htmlView = (View)component.getClientProperty("html");
                if (htmlView == null) {
                    log.warning("JComponent " + component + " does not have an html client property set on it; cannot install a HyperlinkMouseAdapter on it.");
                    this.listener = null;
                } else {
                    Element eachElement;
                    Element rootElement = htmlView.getElement();
                    ElementIterator iterator = new ElementIterator(rootElement);
                    LinkedList<Element> linkElements = new LinkedList<Element>();
                    while ((eachElement = iterator.next()) != null) {
                        AttributeSet attributes;
                        AttributeSet anchor;
                        if (!eachElement.isLeaf() || (anchor = (AttributeSet)(attributes = eachElement.getAttributes()).getAttribute(HTML.Tag.A)) == null) continue;
                        linkElements.add(eachElement);
                    }
                    if (linkElements.size() == 0) {
                        log.config("JComponent " + component + " does not have any clickable links; cannot install a HyperlinkMouseAdapter on it.");
                        this.listener = null;
                    } else {
                        this.listener = listener;
                        this.clickableElements = linkElements.toArray(new Element[linkElements.size()]);
                        this.text = text;
                    }
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.listener == null) {
            return;
        }
        Element clickableElement = this.whichElement(e);
        if (this.currentElement != clickableElement) {
            if (this.currentElement != null) {
                this.listener.hyperlinkUpdate(this.createHyperlinkEvent(e, this.currentElement, HyperlinkEvent.EventType.EXITED));
            }
            if (clickableElement != null) {
                this.listener.hyperlinkUpdate(this.createHyperlinkEvent(e, clickableElement, HyperlinkEvent.EventType.ENTERED));
            }
            this.currentElement = clickableElement;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.listener == null) {
            return;
        }
        Element clickableElement = this.whichElement(e);
        if (clickableElement != null) {
            this.listener.hyperlinkUpdate(this.createHyperlinkEvent(e, clickableElement, HyperlinkEvent.EventType.ACTIVATED));
        }
    }

    private HyperlinkEvent createHyperlinkEvent(MouseEvent event, Element element, HyperlinkEvent.EventType eventType) {
        AttributeSet anchor = (AttributeSet)element.getAttributes().getAttribute(HTML.Tag.A);
        String href = (String)anchor.getAttribute(HTML.Attribute.HREF);
        URL url = null;
        try {
            url = new URL(href);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new HyperlinkEvent(event.getSource(), eventType, url, href, element);
    }

    private Element whichElement(MouseEvent e) {
        int indexAtPoint = this.text.getIndexAtPoint(e.getPoint());
        for (Element element : this.clickableElements) {
            if (indexAtPoint < element.getStartOffset() || indexAtPoint > element.getEndOffset()) continue;
            return element;
        }
        return null;
    }
}

