/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.Component;
import java.text.Format;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class FormattingTableCellRenderer
extends DefaultTableCellRenderer {
    final Format format;
    @Nullable
    final Format tooltipFormat;

    public FormattingTableCellRenderer(Format format) {
        this(format, null);
    }

    public FormattingTableCellRenderer(Format format, @Nullable Format tooltipFormat) {
        this.format = format;
        this.tooltipFormat = tooltipFormat;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String formatted = this.format.format(value);
        if (this.tooltipFormat != null) {
            this.setToolTipText(value == null ? null : this.tooltipFormat.format(value));
        }
        return super.getTableCellRendererComponent(table, formatted, isSelected, hasFocus, row, column);
    }
}

