/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColumnsAutoSizer {
    public static void sizeColumnsToFit(JTable table) {
        ColumnsAutoSizer.sizeColumnsToFit(table, 5);
    }

    public static void sizeColumnsToFit(JTable table, int columnMargin) {
        JTableHeader tableHeader = table.getTableHeader();
        if (tableHeader == null) {
            return;
        }
        FontMetrics headerFontMetrics = tableHeader.getFontMetrics(tableHeader.getFont());
        int[] minWidths = new int[table.getColumnCount()];
        int[] maxWidths = new int[table.getColumnCount()];
        for (int columnIndex = 0; columnIndex < table.getColumnCount(); ++columnIndex) {
            int headerWidth = headerFontMetrics.stringWidth(table.getColumnName(columnIndex));
            minWidths[columnIndex] = headerWidth + columnMargin;
            int maxWidth = ColumnsAutoSizer.getMaximalRequiredColumnWidth(table, columnIndex, headerWidth);
            maxWidths[columnIndex] = Math.max(maxWidth, minWidths[columnIndex]) + columnMargin;
        }
        ColumnsAutoSizer.adjustMaximumWidths(table, minWidths, maxWidths);
        for (int i = 0; i < minWidths.length; ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            if (minWidths[i] > 0) {
                column.setMinWidth(minWidths[i]);
            }
            if (maxWidths[i] <= 0) continue;
            column.setMaxWidth(maxWidths[i]);
            column.setWidth(maxWidths[i]);
            column.setPreferredWidth(maxWidths[i]);
        }
    }

    private static void adjustMaximumWidths(JTable table, int[] minWidths, int[] maxWidths) {
        int width = table.getWidth();
        if (width <= 0) {
            table.setAutoResizeMode(0);
            return;
        }
        if (width > 0) {
            for (int breaker = 0; ColumnsAutoSizer.sum(maxWidths) > width && breaker < 10000; ++breaker) {
                int highestWidthIndex;
                int n = highestWidthIndex = ColumnsAutoSizer.findLargestIndex(maxWidths);
                maxWidths[n] = maxWidths[n] - 1;
                maxWidths[highestWidthIndex] = Math.max(maxWidths[highestWidthIndex], minWidths[highestWidthIndex]);
            }
        }
    }

    private static int getMaximalRequiredColumnWidth(JTable table, int columnIndex, int headerWidth) {
        int maxWidth = headerWidth;
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        for (int row = 0; row < table.getModel().getRowCount(); ++row) {
            TableCellRenderer cellRenderer = table.getCellRenderer(row, columnIndex);
            Component rendererComponent = cellRenderer.getTableCellRendererComponent(table, table.getModel().getValueAt(row, columnIndex), false, false, row, columnIndex);
            double valueWidth = rendererComponent.getPreferredSize().getWidth();
            maxWidth = (int)Math.max((double)maxWidth, valueWidth);
        }
        return maxWidth;
    }

    private static int findLargestIndex(int[] widths) {
        int largestIndex = 0;
        int largestValue = 0;
        for (int i = 0; i < widths.length; ++i) {
            if (widths[i] <= largestValue) continue;
            largestIndex = i;
            largestValue = widths[i];
        }
        return largestIndex;
    }

    private static int sum(int[] widths) {
        int sum = 0;
        for (int width : widths) {
            sum += width;
        }
        return sum;
    }
}

