/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.swing.ColumnTableColumn;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class ColumnTableModel
extends AbstractTableModel {
    private final List<ColumnTableColumn<?>> columns = new ArrayList();

    protected ColumnTableModel() {
        this(new ColumnTableColumn[0]);
    }

    protected ColumnTableModel(ColumnTableColumn<? extends Object> ... columns) {
        for (ColumnTableColumn<? extends Object> eachColumn : columns) {
            this.addColumn(eachColumn);
        }
    }

    public void addColumn(ColumnTableColumn<?> column) {
        this.columns.add(column);
    }

    @Override
    public abstract int getRowCount();

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).getValue(this, rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column).getLabel();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.get(columnIndex).getValueClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).isEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ColumnTableColumn<?> column = this.columns.get(columnIndex);
        column.setValue(this, aValue, rowIndex, columnIndex);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void install(JTable target) {
        target.setModel(this);
        TableModel m = target.getModel();
        if (m != null) {
            TableColumnModel cm = target.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
        }
        int i = 0;
        for (ColumnTableColumn<?> eachColumn : this.columns) {
            target.addColumn(eachColumn.createTableColumn(i++));
        }
    }
}

